/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.config;

import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.web.cors.CorsConfigurationSource;
import xyz.tcheeric.gateway.app.persistence.PostgresUserRepository;
import xyz.tcheeric.gateway.app.security.GatewayUserDetails;
import xyz.tcheeric.gateway.app.security.GatewayUserDetailsService;
import xyz.tcheeric.gateway.app.service.UserService;
import xyz.tcheeric.gateway.rest.user.UserRepository;

@Configuration
@EnableWebSecurity
@ConditionalOnProperty(name={"gateway.web.enabled"}, havingValue="true", matchIfMissing=false)
public class WebSecurityConfiguration {
    @Bean
    @Order(value=1)
    public SecurityFilterChain webSecurityFilterChain(HttpSecurity http, GatewayUserDetailsService userDetailsService, PasswordEncoder passwordEncoder, CorsConfigurationSource corsConfigurationSource) throws Exception {
        http.securityMatcher(new String[]{"/web/**", "/login", "/register", "/logout", "/css/**", "/js/**", "/images/**"}).cors(cors -> cors.configurationSource(corsConfigurationSource)).csrf(csrf -> csrf.disable()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/login", "/register", "/css/**", "/js/**", "/images/**"})).permitAll().requestMatchers(new String[]{"/web/**"})).authenticated()).formLogin(form -> ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)form.loginPage("/login").loginProcessingUrl("/login")).defaultSuccessUrl("/web/dashboard", true)).failureUrl("/login?error=true")).usernameParameter("email").passwordParameter("password").successHandler(this.loginSuccessHandler())).logout(logout -> logout.logoutUrl("/logout").logoutSuccessUrl("/login?logout=true").invalidateHttpSession(true).deleteCookies(new String[]{"JSESSIONID"})).authenticationProvider((AuthenticationProvider)this.authenticationProvider(userDetailsService, passwordEncoder));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public DaoAuthenticationProvider authenticationProvider(GatewayUserDetailsService userDetailsService, PasswordEncoder passwordEncoder) {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)userDetailsService);
        provider.setPasswordEncoder(passwordEncoder);
        return provider;
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration config) throws Exception {
        return config.getAuthenticationManager();
    }

    @Bean
    public AuthenticationSuccessHandler loginSuccessHandler() {
        return (request, response, authentication) -> {
            Object patt0$temp = authentication.getPrincipal();
            if (patt0$temp instanceof GatewayUserDetails) {
                GatewayUserDetails gatewayUserDetails = (GatewayUserDetails)patt0$temp;
            }
            response.sendRedirect("/web/dashboard");
        };
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.web.enabled"}, havingValue="true")
    public UserRepository postgresUserRepository(DataSource dataSource, ObjectProvider<Flyway> flywayProvider) {
        flywayProvider.getIfAvailable();
        return new PostgresUserRepository(dataSource);
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.web.enabled"}, havingValue="true")
    public UserService userService(UserRepository userRepository, PasswordEncoder passwordEncoder) {
        return new UserService(userRepository, passwordEncoder);
    }

    @Bean
    @ConditionalOnProperty(name={"gateway.web.enabled"}, havingValue="true")
    public GatewayUserDetailsService gatewayUserDetailsService(UserService userService) {
        return new GatewayUserDetailsService(userService);
    }
}

