/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.inmemory;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import xyz.tcheeric.gateway.app.inmemory.InMemoryGatewayStore;
import xyz.tcheeric.identity.api.ports.TokenPort;
import xyz.tcheeric.identity.domain.AccessToken;
import xyz.tcheeric.identity.domain.BunkerIdentity;

public class InMemoryTokenPort
implements TokenPort {
    private static final String DEFAULT_RELAY = "wss://relay.nsec.app";
    private final InMemoryGatewayStore store;
    private final String defaultRelay;

    public InMemoryTokenPort(InMemoryGatewayStore store) {
        this(store, DEFAULT_RELAY);
    }

    public InMemoryTokenPort(InMemoryGatewayStore store, String defaultRelay) {
        this.store = store;
        this.defaultRelay = defaultRelay != null && !defaultRelay.isBlank() ? defaultRelay : DEFAULT_RELAY;
    }

    public CompletableFuture<AccessToken> createToken(String keyName, String clientName, String policyId, Duration lifetime) {
        AccessToken token = new AccessToken(keyName, clientName);
        if (policyId != null) {
            token = token.withPolicy(policyId, (String)this.store.findPolicyName(policyId).orElse(null));
        }
        if (lifetime != null) {
            token = token.withExpiration(lifetime);
        }
        token = token.withRelay(this.defaultRelay);
        BunkerIdentity identity = this.store.identitiesByKey().get(keyName);
        AccessToken stored = identity != null ? token.withKeyNpub(identity.getPublicKey().toHex()) : token;
        this.store.tokensById().put(stored.getId(), stored);
        return CompletableFuture.completedFuture(stored);
    }

    public CompletableFuture<Optional<AccessToken>> getToken(String tokenId) {
        return CompletableFuture.completedFuture(Optional.ofNullable(this.store.tokensById().get(tokenId)));
    }

    public CompletableFuture<List<AccessToken>> listTokens(String keyName) {
        return CompletableFuture.completedFuture(this.store.tokensById().values().stream().filter(token -> token.getKeyName().equals(keyName)).toList());
    }

    public CompletableFuture<Boolean> revokeToken(String tokenId) {
        AccessToken token = this.store.tokensById().get(tokenId);
        if (token == null) {
            return CompletableFuture.completedFuture(false);
        }
        token.revoke();
        return CompletableFuture.completedFuture(true);
    }

    public CompletableFuture<Boolean> validateToken(String tokenString) {
        boolean valid = this.store.tokensById().values().stream().filter(t -> Objects.equals(t.getToken(), tokenString)).anyMatch(AccessToken::isValid);
        return CompletableFuture.completedFuture(valid);
    }

    public CompletableFuture<Optional<TokenPort.TokenStats>> getTokenStats(String tokenId) {
        AccessToken token = this.store.tokensById().get(tokenId);
        if (token == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        Long remaining = token.getMaxUsage().map(max -> Math.max(0L, max - token.getUsageCount())).orElse(null);
        Long timeUntilExpiry = token.getExpiresAt().map(expires -> Math.max(0L, expires.toEpochMilli() - Instant.now().toEpochMilli())).orElse(null);
        TokenPort.TokenStats stats = new TokenPort.TokenStats(token.getUsageCount(), token.getLastUsedAt().map(Instant::toEpochMilli).orElse(0L).longValue(), remaining, timeUntilExpiry);
        return CompletableFuture.completedFuture(Optional.of(stats));
    }
}

