/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.inmemory;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Repository;
import xyz.tcheeric.gateway.rest.webhook.WebhookDelivery;
import xyz.tcheeric.gateway.rest.webhook.WebhookDeliveryRepository;

@Repository
public class InMemoryWebhookDeliveryRepository
implements WebhookDeliveryRepository {
    private final Map<String, WebhookDelivery> deliveries = new ConcurrentHashMap<String, WebhookDelivery>();

    public WebhookDelivery save(WebhookDelivery delivery) {
        this.deliveries.put(delivery.getId(), delivery);
        return delivery;
    }

    public Optional<WebhookDelivery> findById(String id) {
        return Optional.ofNullable(this.deliveries.get(id));
    }

    public List<WebhookDelivery> findByWebhookId(String webhookId, int limit, int offset) {
        return this.deliveries.values().stream().filter(d -> d.getWebhookId().equals(webhookId)).sorted(Comparator.comparing(WebhookDelivery::getAttemptedAt).reversed()).skip(offset).limit(limit).toList();
    }

    public int countByWebhookId(String webhookId) {
        return (int)this.deliveries.values().stream().filter(d -> d.getWebhookId().equals(webhookId)).count();
    }

    public List<WebhookDelivery> findByEventId(String eventId) {
        return this.deliveries.values().stream().filter(d -> d.getEventId().equals(eventId)).toList();
    }

    public void deleteByWebhookId(String webhookId) {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (Map.Entry<String, WebhookDelivery> entry : this.deliveries.entrySet()) {
            if (!entry.getValue().getWebhookId().equals(webhookId)) continue;
            toDelete.add(entry.getKey());
        }
        toDelete.forEach(this.deliveries::remove);
    }
}

