/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.inmemory;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Repository;
import xyz.tcheeric.gateway.rest.webhook.Webhook;
import xyz.tcheeric.gateway.rest.webhook.WebhookRepository;

@Repository
public class InMemoryWebhookRepository
implements WebhookRepository {
    private final Map<String, Webhook> webhooks = new ConcurrentHashMap<String, Webhook>();

    public Webhook save(Webhook webhook) {
        this.webhooks.put(webhook.getId(), webhook);
        return webhook;
    }

    public Optional<Webhook> findById(String id) {
        return Optional.ofNullable(this.webhooks.get(id));
    }

    public Optional<Webhook> findByIdAndClientId(String id, String clientId) {
        return this.findById(id).filter(w -> w.getClientId().equals(clientId));
    }

    public List<Webhook> findByClientId(String clientId) {
        return this.webhooks.values().stream().filter(w -> w.getClientId().equals(clientId)).toList();
    }

    public List<Webhook> findByEventType(String eventType) {
        return this.webhooks.values().stream().filter(w -> w.isSubscribedTo(eventType)).toList();
    }

    public boolean existsByClientIdAndUrl(String clientId, String url) {
        return this.webhooks.values().stream().anyMatch(w -> w.getClientId().equals(clientId) && w.getUrl().equals(url));
    }

    public void deleteById(String id) {
        this.webhooks.remove(id);
    }
}

