/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.persistence;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.gateway.rest.apikey.ApiKey;
import xyz.tcheeric.gateway.rest.apikey.ApiKeyRepository;
import xyz.tcheeric.gateway.security.auth.ApiKeyAuthentication;

public class PostgresApiKeyRepository
implements ApiKeyRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresApiKeyRepository.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final DataSource dataSource;

    public PostgresApiKeyRepository(DataSource dataSource) {
        this.dataSource = dataSource;
        LOGGER.info("api_key_repository initialized storage=postgresql");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ApiKey save(ApiKey apiKey) {
        String context = PostgresApiKeyRepository.buildContext("api_key_id=" + apiKey.getApiKeyId(), "client_id=" + apiKey.getClientId());
        LOGGER.debug("api_key_repository save_attempt {}", (Object)context);
        String sql = "INSERT INTO api_keys (api_key_id, client_id, secret_hash, encrypted_secret,\n    name, description, permissions, rate_limit_per_minute, rate_limit_per_hour,\n    expires_at, rotated_from_id, rotation_grace_until)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
        try (Connection conn = this.dataSource.getConnection();){
            ApiKey apiKey2;
            block23: {
                PreparedStatement stmt = conn.prepareStatement(sql, 1);
                try {
                    int idx = 0;
                    stmt.setString(++idx, apiKey.getApiKeyId());
                    stmt.setString(++idx, apiKey.getClientId());
                    stmt.setString(++idx, apiKey.getSecretHash());
                    stmt.setBytes(++idx, apiKey.getEncryptedSecret());
                    this.setNullableString(stmt, ++idx, apiKey.getName());
                    this.setNullableString(stmt, ++idx, apiKey.getDescription());
                    stmt.setString(++idx, this.serializePermissions(apiKey.getPermissions()));
                    stmt.setInt(++idx, apiKey.getRateLimit().requestsPerMinute());
                    stmt.setInt(++idx, apiKey.getRateLimit().requestsPerHour());
                    this.setNullableTimestamp(stmt, ++idx, apiKey.getExpiresAt());
                    this.setNullableString(stmt, ++idx, apiKey.getRotatedFromId());
                    this.setNullableTimestamp(stmt, ++idx, apiKey.getRotationGraceUntil());
                    stmt.executeUpdate();
                    try (ResultSet rs = stmt.getGeneratedKeys();){
                        if (rs.next()) {
                            apiKey.setId(Long.valueOf(rs.getLong(1)));
                        }
                    }
                    if (apiKey.getCreatedAt() == null) {
                        apiKey.setCreatedAt(Instant.now());
                    }
                    LOGGER.info("api_key_repository save_success {} id={}", (Object)context, (Object)apiKey.getId());
                    apiKey2 = apiKey;
                    if (stmt == null) break block23;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return apiKey2;
        }
        catch (SQLException e) {
            LOGGER.error("api_key_repository save_failed {} sql_state={} error={}", new Object[]{context, PostgresApiKeyRepository.safeSqlState(e), e.getMessage(), e});
            throw new ApiKeyPersistenceException("Failed to save API key", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Optional<ApiKey> findByApiKeyId(String apiKeyId) {
        String context = PostgresApiKeyRepository.buildContext("api_key_id=" + apiKeyId);
        LOGGER.debug("api_key_repository find_by_id_attempt {}", (Object)context);
        String sql = "SELECT * FROM api_keys WHERE api_key_id = ?";
        try (Connection conn = this.dataSource.getConnection();){
            Optional<ApiKey> optional;
            block25: {
                ResultSet rs;
                PreparedStatement stmt;
                block22: {
                    Optional<ApiKey> optional2;
                    block24: {
                        block23: {
                            stmt = conn.prepareStatement(sql);
                            stmt.setString(1, apiKeyId);
                            rs = stmt.executeQuery();
                            if (!rs.next()) break block22;
                            ApiKey apiKey = this.mapResultSetToApiKey(rs);
                            LOGGER.debug("api_key_repository find_by_id_success {}", (Object)context);
                            optional2 = Optional.of(apiKey);
                            if (rs == null) break block23;
                            rs.close();
                        }
                        if (stmt == null) break block24;
                        stmt.close();
                    }
                    return optional2;
                }
                try {
                    block26: {
                        if (rs != null) {
                            rs.close();
                        }
                        break block26;
                        {
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    LOGGER.debug("api_key_repository find_by_id_not_found {}", (Object)context);
                    optional = Optional.empty();
                    if (stmt == null) break block25;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            LOGGER.error("api_key_repository find_by_id_failed {} sql_state={} error={}", new Object[]{context, PostgresApiKeyRepository.safeSqlState(e), e.getMessage(), e});
            throw new ApiKeyPersistenceException("Failed to find API key by ID", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Optional<ApiKey> findBySecretHash(String secretHash) {
        LOGGER.debug("api_key_repository find_by_hash_attempt");
        String sql = "SELECT * FROM api_keys WHERE secret_hash = ? AND revoked = FALSE";
        try (Connection conn = this.dataSource.getConnection();){
            Optional<ApiKey> optional;
            block25: {
                ResultSet rs;
                PreparedStatement stmt;
                block22: {
                    Optional<ApiKey> optional2;
                    block24: {
                        block23: {
                            stmt = conn.prepareStatement(sql);
                            stmt.setString(1, secretHash);
                            rs = stmt.executeQuery();
                            if (!rs.next()) break block22;
                            ApiKey apiKey = this.mapResultSetToApiKey(rs);
                            LOGGER.debug("api_key_repository find_by_hash_success api_key_id={}", (Object)apiKey.getApiKeyId());
                            optional2 = Optional.of(apiKey);
                            if (rs == null) break block23;
                            rs.close();
                        }
                        if (stmt == null) break block24;
                        stmt.close();
                    }
                    return optional2;
                }
                try {
                    block26: {
                        if (rs != null) {
                            rs.close();
                        }
                        break block26;
                        {
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    LOGGER.debug("api_key_repository find_by_hash_not_found");
                    optional = Optional.empty();
                    if (stmt == null) break block25;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            LOGGER.error("api_key_repository find_by_hash_failed sql_state={} error={}", new Object[]{PostgresApiKeyRepository.safeSqlState(e), e.getMessage(), e});
            throw new ApiKeyPersistenceException("Failed to find API key by hash", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Optional<ApiKey> findByApiKeyIdAndClientId(String apiKeyId, String clientId) {
        String context = PostgresApiKeyRepository.buildContext("api_key_id=" + apiKeyId, "client_id=" + clientId);
        LOGGER.debug("api_key_repository find_by_id_and_client_attempt {}", (Object)context);
        String sql = "SELECT * FROM api_keys WHERE api_key_id = ? AND client_id = ?";
        try (Connection conn = this.dataSource.getConnection();){
            Optional<ApiKey> optional;
            block25: {
                ResultSet rs;
                PreparedStatement stmt;
                block22: {
                    Optional<ApiKey> optional2;
                    block24: {
                        block23: {
                            stmt = conn.prepareStatement(sql);
                            stmt.setString(1, apiKeyId);
                            stmt.setString(2, clientId);
                            rs = stmt.executeQuery();
                            if (!rs.next()) break block22;
                            ApiKey apiKey = this.mapResultSetToApiKey(rs);
                            LOGGER.debug("api_key_repository find_by_id_and_client_success {}", (Object)context);
                            optional2 = Optional.of(apiKey);
                            if (rs == null) break block23;
                            rs.close();
                        }
                        if (stmt == null) break block24;
                        stmt.close();
                    }
                    return optional2;
                }
                try {
                    block26: {
                        if (rs != null) {
                            rs.close();
                        }
                        break block26;
                        {
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    LOGGER.debug("api_key_repository find_by_id_and_client_not_found {}", (Object)context);
                    optional = Optional.empty();
                    if (stmt == null) break block25;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            LOGGER.error("api_key_repository find_by_id_and_client_failed {} sql_state={} error={}", new Object[]{context, PostgresApiKeyRepository.safeSqlState(e), e.getMessage(), e});
            throw new ApiKeyPersistenceException("Failed to find API key by ID and client", e);
        }
    }

    public List<ApiKey> findByClientId(String clientId) {
        String context = PostgresApiKeyRepository.buildContext("client_id=" + clientId);
        LOGGER.debug("api_key_repository find_by_client_attempt {}", (Object)context);
        String sql = "SELECT * FROM api_keys WHERE client_id = ? ORDER BY created_at DESC";
        return this.executeListQuery(sql, context, stmt -> stmt.setString(1, clientId));
    }

    public List<ApiKey> findActiveByClientId(String clientId) {
        String context = PostgresApiKeyRepository.buildContext("client_id=" + clientId);
        LOGGER.debug("api_key_repository find_active_by_client_attempt {}", (Object)context);
        String sql = "SELECT * FROM api_keys\nWHERE client_id = ?\n  AND revoked = FALSE\n  AND (expires_at IS NULL OR expires_at > CURRENT_TIMESTAMP)\nORDER BY created_at DESC\n";
        return this.executeListQuery(sql, context, stmt -> stmt.setString(1, clientId));
    }

    public List<ApiKey> findAllActive() {
        LOGGER.debug("api_key_repository find_all_active_attempt");
        String sql = "SELECT * FROM api_keys\nWHERE revoked = FALSE\n  AND (expires_at IS NULL OR expires_at > CURRENT_TIMESTAMP)\n";
        return this.executeListQuery(sql, "all_active", stmt -> {});
    }

    public void updateLastUsedAt(String apiKeyId) {
        String context = PostgresApiKeyRepository.buildContext("api_key_id=" + apiKeyId);
        LOGGER.debug("api_key_repository update_last_used_attempt {}", (Object)context);
        String sql = "UPDATE api_keys SET last_used_at = CURRENT_TIMESTAMP WHERE api_key_id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, apiKeyId);
            int updated = stmt.executeUpdate();
            if (updated > 0) {
                LOGGER.debug("api_key_repository update_last_used_success {}", (Object)context);
            } else {
                LOGGER.warn("api_key_repository update_last_used_not_found {}", (Object)context);
            }
        }
        catch (SQLException e) {
            LOGGER.error("api_key_repository update_last_used_failed {} sql_state={} error={}", new Object[]{context, PostgresApiKeyRepository.safeSqlState(e), e.getMessage(), e});
            throw new ApiKeyPersistenceException("Failed to update last used timestamp", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean markRevoked(String apiKeyId) {
        String context = PostgresApiKeyRepository.buildContext("api_key_id=" + apiKeyId);
        LOGGER.debug("api_key_repository mark_revoked_attempt {}", (Object)context);
        String sql = "UPDATE api_keys SET revoked = TRUE, revoked_at = CURRENT_TIMESTAMP WHERE api_key_id = ? AND revoked = FALSE";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block18: {
                PreparedStatement stmt;
                block16: {
                    boolean bl2;
                    block17: {
                        stmt = conn.prepareStatement(sql);
                        try {
                            stmt.setString(1, apiKeyId);
                            int updated = stmt.executeUpdate();
                            if (updated <= 0) break block16;
                            LOGGER.info("api_key_repository mark_revoked_success {}", (Object)context);
                            bl2 = true;
                            if (stmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return bl2;
                }
                LOGGER.warn("api_key_repository mark_revoked_not_found {}", (Object)context);
                bl = false;
                if (stmt == null) break block18;
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error("api_key_repository mark_revoked_failed {} sql_state={} error={}", new Object[]{context, PostgresApiKeyRepository.safeSqlState(e), e.getMessage(), e});
            throw new ApiKeyPersistenceException("Failed to revoke API key", e);
        }
    }

    public List<ApiKey> findExpiredGracePeriodKeys() {
        LOGGER.debug("api_key_repository find_expired_grace_period_attempt");
        String sql = "SELECT * FROM api_keys\nWHERE rotation_grace_until IS NOT NULL\n  AND rotation_grace_until < CURRENT_TIMESTAMP\n  AND revoked = FALSE\n";
        return this.executeListQuery(sql, "expired_grace_period", stmt -> {});
    }

    public void recordAuditEvent(String apiKeyId, String eventType, String details, String performedBy, String ipAddress) {
        String context = PostgresApiKeyRepository.buildContext("api_key_id=" + apiKeyId, "event_type=" + eventType);
        LOGGER.debug("api_key_repository record_audit_attempt {}", (Object)context);
        String sql = "INSERT INTO api_key_audit (api_key_id, event_type, event_details, performed_by, ip_address)\nVALUES (?, ?, ?, ?, ?)\n";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, apiKeyId);
            stmt.setString(2, eventType);
            this.setNullableString(stmt, 3, details);
            this.setNullableString(stmt, 4, performedBy);
            this.setNullableString(stmt, 5, ipAddress);
            stmt.executeUpdate();
            LOGGER.debug("api_key_repository record_audit_success {}", (Object)context);
        }
        catch (SQLException e) {
            LOGGER.error("api_key_repository record_audit_failed {} sql_state={} error={}", new Object[]{context, PostgresApiKeyRepository.safeSqlState(e), e.getMessage(), e});
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<ApiKey> executeListQuery(String sql, String context, StatementPreparer preparer) {
        ArrayList<ApiKey> results = new ArrayList<ApiKey>();
        try (Connection conn = this.dataSource.getConnection();){
            ArrayList<ApiKey> arrayList;
            block22: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    preparer.prepare(stmt);
                    try (ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            results.add(this.mapResultSetToApiKey(rs));
                        }
                    }
                    LOGGER.debug("api_key_repository list_success {} count={}", (Object)context, (Object)results.size());
                    arrayList = results;
                    if (stmt == null) break block22;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            LOGGER.error("api_key_repository list_failed {} sql_state={} error={}", new Object[]{context, PostgresApiKeyRepository.safeSqlState(e), e.getMessage(), e});
            throw new ApiKeyPersistenceException("Failed to list API keys", e);
        }
    }

    private ApiKey mapResultSetToApiKey(ResultSet rs) throws SQLException {
        ApiKey apiKey = new ApiKey();
        apiKey.setId(Long.valueOf(rs.getLong("id")));
        apiKey.setApiKeyId(rs.getString("api_key_id"));
        apiKey.setClientId(rs.getString("client_id"));
        apiKey.setSecretHash(rs.getString("secret_hash"));
        apiKey.setEncryptedSecret(rs.getBytes("encrypted_secret"));
        apiKey.setName(rs.getString("name"));
        apiKey.setDescription(rs.getString("description"));
        apiKey.setPermissions(this.deserializePermissions(rs.getString("permissions")));
        apiKey.setRateLimit(new ApiKeyAuthentication.RateLimitConfig(rs.getInt("rate_limit_per_minute"), rs.getInt("rate_limit_per_hour")));
        apiKey.setCreatedAt(this.getNullableInstant(rs, "created_at"));
        apiKey.setExpiresAt(this.getNullableInstant(rs, "expires_at"));
        apiKey.setLastUsedAt(this.getNullableInstant(rs, "last_used_at"));
        apiKey.setRevoked(rs.getBoolean("revoked"));
        apiKey.setRevokedAt(this.getNullableInstant(rs, "revoked_at"));
        apiKey.setRotatedFromId(rs.getString("rotated_from_id"));
        apiKey.setRotationGraceUntil(this.getNullableInstant(rs, "rotation_grace_until"));
        return apiKey;
    }

    private String serializePermissions(Set<String> permissions) {
        try {
            return OBJECT_MAPPER.writeValueAsString(permissions);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("api_key_repository serialize_permissions_failed using_default error={}", (Object)e.getMessage());
            return "[\"*\"]";
        }
    }

    private Set<String> deserializePermissions(String json) {
        if (json == null || json.isBlank()) {
            return Set.of("*");
        }
        try {
            return (Set)OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<Set<String>>(this){});
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("api_key_repository deserialize_permissions_failed using_default error={}", (Object)e.getMessage());
            return Set.of("*");
        }
    }

    private void setNullableString(PreparedStatement stmt, int index, String value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 12);
        } else {
            stmt.setString(index, value);
        }
    }

    private void setNullableTimestamp(PreparedStatement stmt, int index, Instant instant) throws SQLException {
        if (instant == null) {
            stmt.setNull(index, 2014);
        } else {
            stmt.setTimestamp(index, Timestamp.from(instant));
        }
    }

    private Instant getNullableInstant(ResultSet rs, String column) throws SQLException {
        Timestamp ts = rs.getTimestamp(column);
        return ts != null ? ts.toInstant() : null;
    }

    private static String buildContext(String ... entries) {
        StringJoiner joiner = new StringJoiner(" ");
        for (String entry : entries) {
            if (entry == null || entry.isBlank()) continue;
            joiner.add(entry);
        }
        return joiner.toString();
    }

    private static String safeSqlState(SQLException e) {
        String sqlState = e.getSQLState();
        return sqlState == null ? "n/a" : sqlState;
    }

    public static class ApiKeyPersistenceException
    extends RuntimeException {
        public ApiKeyPersistenceException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @FunctionalInterface
    private static interface StatementPreparer {
        public void prepare(PreparedStatement var1) throws SQLException;
    }
}

