/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.gateway.rest.user.User;
import xyz.tcheeric.gateway.rest.user.UserRepository;

public class PostgresUserRepository
implements UserRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresUserRepository.class);
    private final DataSource dataSource;

    public PostgresUserRepository(DataSource dataSource) {
        this.dataSource = dataSource;
        LOGGER.info("user_repository initialized storage=postgresql");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public User save(User user) {
        LOGGER.debug("user_repository save_attempt email={}", (Object)user.getEmail());
        String sql = "INSERT INTO users (email, password_hash, client_id, display_name, enabled)\nVALUES (?, ?, ?, ?, ?)\n";
        try (Connection conn = this.dataSource.getConnection();){
            User user2;
            block23: {
                PreparedStatement stmt = conn.prepareStatement(sql, 1);
                try {
                    stmt.setString(1, user.getEmail());
                    stmt.setString(2, user.getPasswordHash());
                    stmt.setString(3, user.getClientId());
                    this.setNullableString(stmt, 4, user.getDisplayName());
                    stmt.setBoolean(5, user.isEnabled());
                    stmt.executeUpdate();
                    try (ResultSet rs = stmt.getGeneratedKeys();){
                        if (rs.next()) {
                            user.setId(Long.valueOf(rs.getLong(1)));
                        }
                    }
                    if (user.getCreatedAt() == null) {
                        user.setCreatedAt(Instant.now());
                    }
                    LOGGER.info("user_repository save_success email={} client_id={}", (Object)user.getEmail(), (Object)user.getClientId());
                    user2 = user;
                    if (stmt == null) break block23;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return user2;
        }
        catch (SQLException e) {
            LOGGER.error("user_repository save_failed email={} sql_state={} error={}", new Object[]{user.getEmail(), PostgresUserRepository.safeSqlState(e), e.getMessage(), e});
            throw new UserPersistenceException("Failed to save user", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Optional<User> findByEmail(String email) {
        LOGGER.debug("user_repository find_by_email_attempt email={}", (Object)email);
        String sql = "SELECT * FROM users WHERE email = ?";
        try (Connection conn = this.dataSource.getConnection();){
            Optional<User> optional;
            block25: {
                ResultSet rs;
                PreparedStatement stmt;
                block22: {
                    Optional<User> optional2;
                    block24: {
                        block23: {
                            stmt = conn.prepareStatement(sql);
                            stmt.setString(1, email);
                            rs = stmt.executeQuery();
                            if (!rs.next()) break block22;
                            User user = this.mapResultSetToUser(rs);
                            LOGGER.debug("user_repository find_by_email_success email={}", (Object)email);
                            optional2 = Optional.of(user);
                            if (rs == null) break block23;
                            rs.close();
                        }
                        if (stmt == null) break block24;
                        stmt.close();
                    }
                    return optional2;
                }
                try {
                    block26: {
                        if (rs != null) {
                            rs.close();
                        }
                        break block26;
                        {
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    LOGGER.debug("user_repository find_by_email_not_found email={}", (Object)email);
                    optional = Optional.empty();
                    if (stmt == null) break block25;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            LOGGER.error("user_repository find_by_email_failed email={} sql_state={} error={}", new Object[]{email, PostgresUserRepository.safeSqlState(e), e.getMessage(), e});
            throw new UserPersistenceException("Failed to find user by email", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Optional<User> findByClientId(String clientId) {
        LOGGER.debug("user_repository find_by_client_id_attempt client_id={}", (Object)clientId);
        String sql = "SELECT * FROM users WHERE client_id = ?";
        try (Connection conn = this.dataSource.getConnection();){
            Optional<User> optional;
            block25: {
                ResultSet rs;
                PreparedStatement stmt;
                block22: {
                    Optional<User> optional2;
                    block24: {
                        block23: {
                            stmt = conn.prepareStatement(sql);
                            stmt.setString(1, clientId);
                            rs = stmt.executeQuery();
                            if (!rs.next()) break block22;
                            User user = this.mapResultSetToUser(rs);
                            LOGGER.debug("user_repository find_by_client_id_success client_id={}", (Object)clientId);
                            optional2 = Optional.of(user);
                            if (rs == null) break block23;
                            rs.close();
                        }
                        if (stmt == null) break block24;
                        stmt.close();
                    }
                    return optional2;
                }
                try {
                    block26: {
                        if (rs != null) {
                            rs.close();
                        }
                        break block26;
                        {
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                    }
                    LOGGER.debug("user_repository find_by_client_id_not_found client_id={}", (Object)clientId);
                    optional = Optional.empty();
                    if (stmt == null) break block25;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return optional;
        }
        catch (SQLException e) {
            LOGGER.error("user_repository find_by_client_id_failed client_id={} sql_state={} error={}", new Object[]{clientId, PostgresUserRepository.safeSqlState(e), e.getMessage(), e});
            throw new UserPersistenceException("Failed to find user by client ID", e);
        }
    }

    /*
     * Exception decompiling
     */
    public boolean existsByEmail(String email) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updateLastLogin(String email) {
        LOGGER.debug("user_repository update_last_login_attempt email={}", (Object)email);
        String sql = "UPDATE users SET last_login_at = CURRENT_TIMESTAMP WHERE email = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, email);
            int updated = stmt.executeUpdate();
            if (updated > 0) {
                LOGGER.debug("user_repository update_last_login_success email={}", (Object)email);
            } else {
                LOGGER.warn("user_repository update_last_login_not_found email={}", (Object)email);
            }
        }
        catch (SQLException e) {
            LOGGER.error("user_repository update_last_login_failed email={} sql_state={} error={}", new Object[]{email, PostgresUserRepository.safeSqlState(e), e.getMessage(), e});
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean disable(String email) {
        LOGGER.debug("user_repository disable_attempt email={}", (Object)email);
        String sql = "UPDATE users SET enabled = FALSE WHERE email = ? AND enabled = TRUE";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block18: {
                PreparedStatement stmt;
                block16: {
                    boolean bl2;
                    block17: {
                        stmt = conn.prepareStatement(sql);
                        try {
                            stmt.setString(1, email);
                            int updated = stmt.executeUpdate();
                            if (updated <= 0) break block16;
                            LOGGER.info("user_repository disable_success email={}", (Object)email);
                            bl2 = true;
                            if (stmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return bl2;
                }
                LOGGER.warn("user_repository disable_not_found email={}", (Object)email);
                bl = false;
                if (stmt == null) break block18;
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error("user_repository disable_failed email={} sql_state={} error={}", new Object[]{email, PostgresUserRepository.safeSqlState(e), e.getMessage(), e});
            throw new UserPersistenceException("Failed to disable user", e);
        }
    }

    private User mapResultSetToUser(ResultSet rs) throws SQLException {
        User user = new User();
        user.setId(Long.valueOf(rs.getLong("id")));
        user.setEmail(rs.getString("email"));
        user.setPasswordHash(rs.getString("password_hash"));
        user.setClientId(rs.getString("client_id"));
        user.setDisplayName(rs.getString("display_name"));
        user.setEnabled(rs.getBoolean("enabled"));
        user.setCreatedAt(this.getNullableInstant(rs, "created_at"));
        user.setLastLoginAt(this.getNullableInstant(rs, "last_login_at"));
        return user;
    }

    private void setNullableString(PreparedStatement stmt, int index, String value) throws SQLException {
        if (value == null) {
            stmt.setNull(index, 12);
        } else {
            stmt.setString(index, value);
        }
    }

    private Instant getNullableInstant(ResultSet rs, String column) throws SQLException {
        Timestamp ts = rs.getTimestamp(column);
        return ts != null ? ts.toInstant() : null;
    }

    private static String safeSqlState(SQLException e) {
        String sqlState = e.getSQLState();
        return sqlState == null ? "n/a" : sqlState;
    }

    public static class UserPersistenceException
    extends RuntimeException {
        public UserPersistenceException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

