/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.security;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import xyz.tcheeric.gateway.security.auth.ApiKeyAuthentication;
import xyz.tcheeric.gateway.security.auth.ApiKeyStore;

public class InMemoryApiKeyStore
implements ApiKeyStore {
    private final Map<String, StoredKey> keysById = new ConcurrentHashMap<String, StoredKey>();
    private final Map<String, StoredKey> keysByHash = new ConcurrentHashMap<String, StoredKey>();
    private final SecureRandom random = new SecureRandom();

    public Optional<ApiKeyAuthentication> validate(String apiKey) {
        String hash = this.hash(apiKey);
        StoredKey stored = this.keysByHash.get(hash);
        if (stored == null || stored.revoked) {
            return Optional.empty();
        }
        ApiKeyAuthentication auth = new ApiKeyAuthentication(stored.clientId, stored.apiKeyId, stored.permissions, stored.rateLimit);
        return Optional.of(auth);
    }

    public ApiKeyStore.ApiKeyCreationResult create(String clientId, Set<String> permissions, ApiKeyAuthentication.RateLimitConfig rateLimit) {
        String apiKeyId = "key_" + Math.abs(this.random.nextInt());
        String apiKey = this.generateKey();
        String hash = this.hash(apiKey);
        StoredKey stored = new StoredKey(apiKeyId, clientId, permissions, rateLimit, hash, false);
        this.keysById.put(apiKeyId, stored);
        this.keysByHash.put(hash, stored);
        return new ApiKeyStore.ApiKeyCreationResult(apiKeyId, apiKey, clientId);
    }

    public boolean revoke(String apiKeyId) {
        StoredKey stored = this.keysById.get(apiKeyId);
        if (stored == null) {
            return false;
        }
        stored.revoked = true;
        this.keysByHash.values().removeIf(k -> k.apiKeyId.equals(apiKeyId));
        return true;
    }

    private String generateKey() {
        byte[] bytes = new byte[24];
        this.random.nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    private String hash(String value) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashed = digest.digest(value.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hashed);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 not available", e);
        }
    }

    private static class StoredKey {
        private final String apiKeyId;
        private final String clientId;
        private final Set<String> permissions;
        private final ApiKeyAuthentication.RateLimitConfig rateLimit;
        private final String hash;
        private volatile boolean revoked;

        private StoredKey(String apiKeyId, String clientId, Set<String> permissions, ApiKeyAuthentication.RateLimitConfig rateLimit, String hash, boolean revoked) {
            this.apiKeyId = apiKeyId;
            this.clientId = clientId;
            this.permissions = permissions;
            this.rateLimit = rateLimit;
            this.hash = hash;
            this.revoked = revoked;
        }
    }
}

