/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.gateway.app.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import xyz.tcheeric.gateway.app.service.UserService;

@Controller
@ConditionalOnProperty(name={"gateway.web.enabled"}, havingValue="true", matchIfMissing=false)
public class AuthController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthController.class);
    private final UserService userService;

    public AuthController(UserService userService) {
        this.userService = userService;
    }

    @GetMapping(value={"/login"})
    public String loginPage(@RequestParam(required=false) String error, @RequestParam(required=false) String logout, Model model) {
        if (error != null) {
            model.addAttribute("error", (Object)"Invalid email or password");
        }
        if (logout != null) {
            model.addAttribute("message", (Object)"You have been logged out");
        }
        return "login";
    }

    @GetMapping(value={"/register"})
    public String registerPage() {
        return "register";
    }

    @PostMapping(value={"/register"})
    public String processRegistration(@RequestParam String email, @RequestParam String password, @RequestParam String confirmPassword, @RequestParam(required=false) String displayName, RedirectAttributes redirectAttributes) {
        LOGGER.debug("auth_controller registration_attempt email={}", (Object)email);
        if (!password.equals(confirmPassword)) {
            redirectAttributes.addFlashAttribute("error", (Object)"Passwords do not match");
            return "redirect:/register";
        }
        try {
            UserService.RegistrationResult result = this.userService.register(email, password, displayName);
            LOGGER.info("auth_controller registration_success email={} client_id={}", (Object)result.email(), (Object)result.clientId());
            redirectAttributes.addFlashAttribute("message", (Object)"Registration successful! Please log in.");
            return "redirect:/login";
        }
        catch (UserService.UserRegistrationException e) {
            LOGGER.warn("auth_controller registration_failed email={} reason={}", (Object)email, (Object)e.getMessage());
            redirectAttributes.addFlashAttribute("error", (Object)e.getMessage());
            return "redirect:/register";
        }
    }
}

