/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.bunker;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.exceptions.IdentityException;
import xyz.tcheeric.identity.api.ports.BunkerConnectionPort;
import xyz.tcheeric.identity.api.ports.BunkerIdentityRepository;

public class DeleteBunkerIdentityUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteBunkerIdentityUseCase.class);
    private final BunkerConnectionPort connectionPort;
    private final BunkerIdentityRepository identityRepository;

    public DeleteBunkerIdentityUseCase(BunkerConnectionPort connectionPort, BunkerIdentityRepository identityRepository) {
        this.connectionPort = Objects.requireNonNull(connectionPort, "Connection port cannot be null");
        this.identityRepository = Objects.requireNonNull(identityRepository, "Identity repository cannot be null");
    }

    public CompletableFuture<DeleteResult> execute(String keyName) {
        return this.execute(keyName, false);
    }

    public CompletableFuture<DeleteResult> execute(String keyName, boolean force) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.info("delete_bunker_identity_started key_name={} force={}", (Object)keyName, (Object)force);
        return ((CompletableFuture)this.identityRepository.existsByKeyName(keyName).thenCompose(existsLocally -> {
            if (!existsLocally.booleanValue() && !force) {
                LOGGER.warn("delete_identity_rejected key_name={} reason=not_found", (Object)keyName);
                return CompletableFuture.failedFuture((Throwable)new IdentityException("Identity with key name '" + keyName + "' not found locally. Suggestion: Verify the key name or use --force to attempt bunker deletion anyway."));
            }
            return this.deleteFromBunker(keyName, force).thenCompose(deletedFromBunker -> this.deleteFromLocal(keyName, (boolean)deletedFromBunker));
        })).whenComplete((result, ex) -> {
            if (ex != null) {
                LOGGER.error("delete_bunker_identity_failed key_name={} error={}", (Object)keyName, (Object)ex.getMessage());
            } else {
                LOGGER.info("delete_bunker_identity_complete key_name={} bunker={} local={}", new Object[]{keyName, result.deletedFromBunker(), result.deletedFromLocal()});
            }
        });
    }

    private CompletableFuture<Boolean> deleteFromBunker(String keyName, boolean force) {
        LOGGER.debug("bunker_delete_key key_name={}", (Object)keyName);
        return this.connectionPort.deleteKey(keyName).exceptionally(ex -> {
            if (force) {
                LOGGER.warn("bunker_delete_key_failed key_name={} force=true error={}", (Object)keyName, (Object)ex.getMessage());
                return false;
            }
            throw new IdentityException("Failed to delete key '" + keyName + "' from bunker: " + ex.getMessage() + ". Suggestion: Check bunker connectivity or use --force to delete local record only.", ex);
        });
    }

    private CompletableFuture<DeleteResult> deleteFromLocal(String keyName, boolean deletedFromBunker) {
        LOGGER.debug("delete_local_identity key_name={}", (Object)keyName);
        return ((CompletableFuture)this.identityRepository.deleteByKeyName(keyName).thenApply(v -> new DeleteResult(true, deletedFromBunker, true))).exceptionally(ex -> {
            LOGGER.warn("delete_local_identity_failed key_name={} error={}", (Object)keyName, (Object)ex.getMessage());
            if (deletedFromBunker) {
                return new DeleteResult(true, true, false);
            }
            throw new IdentityException("Failed to delete local identity record: " + ex.getMessage() + ". Suggestion: Check local storage permissions and retry.", ex);
        });
    }

    public record DeleteResult(boolean success, boolean deletedFromBunker, boolean deletedFromLocal) {
        public static DeleteResult fullSuccess() {
            return new DeleteResult(true, true, true);
        }

        public static DeleteResult bunkerOnlySuccess() {
            return new DeleteResult(true, true, false);
        }

        public static DeleteResult localOnlySuccess() {
            return new DeleteResult(true, false, true);
        }

        public static DeleteResult failed() {
            return new DeleteResult(false, false, false);
        }

        public boolean isComplete() {
            return this.deletedFromBunker && this.deletedFromLocal;
        }

        public boolean isPartial() {
            return this.success && this.deletedFromBunker != this.deletedFromLocal;
        }
    }
}

