/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.bunker;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.exceptions.IdentityException;
import xyz.tcheeric.identity.api.exceptions.IdentityNotFoundException;
import xyz.tcheeric.identity.api.ports.BunkerIdentityRepository;
import xyz.tcheeric.identity.api.ports.SigningPort;
import xyz.tcheeric.identity.domain.BunkerIdentity;
import xyz.tcheeric.identity.domain.NostrEvent;

public class SignEventWithBunkerUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignEventWithBunkerUseCase.class);
    private final SigningPort signingPort;
    private final BunkerIdentityRepository identityRepository;

    public SignEventWithBunkerUseCase(SigningPort signingPort, BunkerIdentityRepository identityRepository) {
        this.signingPort = Objects.requireNonNull(signingPort, "Signing port cannot be null");
        this.identityRepository = Objects.requireNonNull(identityRepository, "Identity repository cannot be null");
    }

    public CompletableFuture<SigningPort.SignedEventResult> execute(String keyName, NostrEvent event) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        Objects.requireNonNull(event, "Event cannot be null");
        LOGGER.debug("sign_event_started key_name={} kind={}", (Object)keyName, (Object)event.kind());
        return ((CompletableFuture)this.identityRepository.findByKeyName(keyName).thenCompose(optIdentity -> {
            BunkerIdentity identity = (BunkerIdentity)optIdentity.orElseThrow(() -> new IdentityNotFoundException("Bunker identity with key name '" + keyName + "' not found. Suggestion: Check the key name or create/import the identity first."));
            if (identity.isLocked()) {
                LOGGER.warn("sign_event_rejected key_name={} reason=identity_locked", (Object)keyName);
                return CompletableFuture.failedFuture((Throwable)new IdentityException("Identity '" + keyName + "' is locked. Suggestion: Unlock the identity with the passphrase before signing."));
            }
            return this.signEvent(identity, event);
        })).whenComplete((result, ex) -> {
            if (ex != null) {
                LOGGER.error("sign_event_failed key_name={} kind={} error={}", new Object[]{keyName, event.kind(), ex.getMessage()});
            } else {
                LOGGER.info("sign_event_complete key_name={} kind={} event_id={}", new Object[]{keyName, event.kind(), result.eventId() != null ? result.eventId().substring(0, 16) : "null"});
            }
        });
    }

    public CompletableFuture<SigningPort.SignedEventResult> executeById(String identityId, NostrEvent event) {
        Objects.requireNonNull(identityId, "Identity ID cannot be null");
        Objects.requireNonNull(event, "Event cannot be null");
        LOGGER.debug("sign_event_started identity_id={} kind={}", (Object)identityId, (Object)event.kind());
        return ((CompletableFuture)this.identityRepository.findById(identityId).thenCompose(optIdentity -> {
            BunkerIdentity identity = (BunkerIdentity)optIdentity.orElseThrow(() -> new IdentityNotFoundException("Bunker identity with ID '" + identityId + "' not found. Suggestion: Check the identity ID or create/import the identity first."));
            if (identity.isLocked()) {
                LOGGER.warn("sign_event_rejected identity_id={} reason=identity_locked", (Object)identityId);
                return CompletableFuture.failedFuture((Throwable)new IdentityException("Identity '" + identity.getKeyName() + "' is locked. Suggestion: Unlock the identity with the passphrase before signing."));
            }
            return this.signEvent(identity, event);
        })).whenComplete((result, ex) -> {
            if (ex != null) {
                LOGGER.error("sign_event_failed identity_id={} kind={} error={}", new Object[]{identityId, event.kind(), ex.getMessage()});
            } else {
                LOGGER.info("sign_event_complete identity_id={} kind={} event_id={}", new Object[]{identityId, event.kind(), result.eventId() != null ? result.eventId().substring(0, 16) : "null"});
            }
        });
    }

    private CompletableFuture<SigningPort.SignedEventResult> signEvent(BunkerIdentity identity, NostrEvent event) {
        LOGGER.debug("bunker_sign_event identity={} kind={}", (Object)identity.getKeyName(), (Object)event.kind());
        return this.signingPort.signEvent(identity, event).exceptionally(ex -> {
            throw new IdentityException("Failed to sign event with identity '" + identity.getKeyName() + "': " + ex.getMessage() + ". Suggestion: Check bunker connectivity and verify the identity is unlocked.", ex);
        });
    }
}

