/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.policy;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.domain.SigningPolicy;

public class DeletePolicyUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeletePolicyUseCase.class);
    private final PolicyPort policyPort;

    public DeletePolicyUseCase(PolicyPort policyPort) {
        this.policyPort = Objects.requireNonNull(policyPort, "Policy port cannot be null");
    }

    public CompletableFuture<DeletePolicyResult> execute(String policyId) {
        Objects.requireNonNull(policyId, "Policy ID cannot be null");
        LOGGER.info("delete_policy_started policy_id={}", (Object)policyId);
        return ((CompletableFuture)((CompletableFuture)this.policyPort.getPolicy(policyId).thenCompose(optionalPolicy -> {
            if (optionalPolicy.isEmpty()) {
                LOGGER.warn("delete_policy_rejected policy_id={} reason=not_found", (Object)policyId);
                return CompletableFuture.completedFuture(DeletePolicyResult.notFound(policyId));
            }
            String policyName = ((SigningPolicy)optionalPolicy.get()).getName();
            return this.policyPort.deletePolicy(policyId).thenApply(deleted -> {
                if (deleted.booleanValue()) {
                    return DeletePolicyResult.success(policyId, policyName);
                }
                return DeletePolicyResult.failure(policyId, "Policy deletion returned false. Policy may have already been deleted.");
            });
        })).whenComplete((result, error) -> {
            if (error != null) {
                LOGGER.error("delete_policy_failed policy_id={} error={}", new Object[]{policyId, error.getMessage(), error});
            } else if (result.success()) {
                LOGGER.info("delete_policy_complete policy_id={} policy_name={}", (Object)policyId, (Object)result.policyName());
            } else {
                LOGGER.warn("delete_policy_incomplete policy_id={} reason={}", (Object)policyId, (Object)result.errorMessage());
            }
        })).exceptionally(error -> DeletePolicyResult.failure(policyId, error.getMessage()));
    }

    public record DeletePolicyResult(boolean success, String policyId, String policyName, String errorMessage) {
        public static DeletePolicyResult success(String policyId, String policyName) {
            return new DeletePolicyResult(true, policyId, policyName, null);
        }

        public static DeletePolicyResult notFound(String policyId) {
            return new DeletePolicyResult(false, policyId, null, "Policy not found: " + policyId);
        }

        public static DeletePolicyResult failure(String policyId, String errorMessage) {
            return new DeletePolicyResult(false, policyId, null, errorMessage);
        }

        public boolean isNotFound() {
            return !this.success && this.errorMessage != null && this.errorMessage.contains("not found");
        }
    }
}

