/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.policy;

import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.exceptions.IdentityException;
import xyz.tcheeric.identity.api.ports.PolicyPort;
import xyz.tcheeric.identity.domain.PolicyRule;
import xyz.tcheeric.identity.domain.SigningPolicy;

public class UpdatePolicyUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdatePolicyUseCase.class);
    private final PolicyPort policyPort;

    public UpdatePolicyUseCase(PolicyPort policyPort) {
        this.policyPort = Objects.requireNonNull(policyPort, "Policy port cannot be null");
    }

    public CompletableFuture<SigningPolicy> execute(UpdatePolicyRequest request) {
        Objects.requireNonNull(request, "Request cannot be null");
        LOGGER.info("update_policy_started policy_id={}", (Object)request.policyId());
        return ((CompletableFuture)this.policyPort.getPolicy(request.policyId()).thenCompose(optionalPolicy -> {
            if (optionalPolicy.isEmpty()) {
                LOGGER.warn("update_policy_rejected policy_id={} reason=not_found", (Object)request.policyId());
                return CompletableFuture.failedFuture((Throwable)new IdentityException("Policy not found: " + request.policyId() + ". Suggestion: Verify the policy ID is correct or list all policies."));
            }
            SigningPolicy existingPolicy = (SigningPolicy)optionalPolicy.get();
            SigningPolicy updatedPolicy = this.applyUpdates(existingPolicy, request);
            return this.policyPort.updatePolicy(updatedPolicy);
        })).whenComplete((updated, error) -> {
            if (error != null) {
                LOGGER.error("update_policy_failed policy_id={} error={}", new Object[]{request.policyId(), error.getMessage(), error});
            } else {
                LOGGER.info("update_policy_complete policy_id={} policy_name={}", (Object)updated.getId(), (Object)updated.getName());
            }
        });
    }

    private SigningPolicy applyUpdates(SigningPolicy existing, UpdatePolicyRequest request) {
        String name = request.name() != null ? request.name() : existing.getName();
        String description = request.description() != null ? request.description() : (String)existing.getDescription().orElse(null);
        List rules = request.rules() != null ? request.rules() : existing.getRules();
        Instant expiresAt = request.expiresAt() != null ? request.expiresAt() : (Instant)existing.getExpiresAt().orElse(null);
        boolean active = request.active() != null ? request.active().booleanValue() : existing.isActive();
        return new SigningPolicy(existing.getId(), name, description, rules, existing.getCreatedAt(), expiresAt, active);
    }

    public record UpdatePolicyRequest(String policyId, String name, String description, List<PolicyRule> rules, Instant expiresAt, Boolean active) {
        public UpdatePolicyRequest {
            Objects.requireNonNull(policyId, "Policy ID cannot be null");
            if (policyId.trim().isEmpty()) {
                throw new IllegalArgumentException("Policy ID cannot be empty");
            }
        }

        public static UpdatePolicyRequest updateName(String policyId, String newName) {
            return new UpdatePolicyRequest(policyId, newName, null, null, null, null);
        }

        public static UpdatePolicyRequest updateActive(String policyId, boolean active) {
            return new UpdatePolicyRequest(policyId, null, null, null, null, active);
        }

        public static UpdatePolicyRequest updateRules(String policyId, List<PolicyRule> rules) {
            return new UpdatePolicyRequest(policyId, null, null, rules, null, null);
        }

        public static UpdatePolicyRequest updateExpiration(String policyId, Instant expiresAt) {
            return new UpdatePolicyRequest(policyId, null, null, null, expiresAt, null);
        }
    }

    public record UpdatePolicyResult(boolean success, SigningPolicy policy, String errorMessage) {
        public static UpdatePolicyResult success(SigningPolicy policy) {
            Objects.requireNonNull(policy, "Policy cannot be null for success result");
            return new UpdatePolicyResult(true, policy, null);
        }

        public static UpdatePolicyResult failure(String errorMessage) {
            Objects.requireNonNull(errorMessage, "Error message cannot be null for failure result");
            return new UpdatePolicyResult(false, null, errorMessage);
        }
    }
}

