/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.identity.application.usecases.token;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.identity.api.ports.TokenPort;
import xyz.tcheeric.identity.domain.AccessToken;

public class RevokeAccessTokenUseCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RevokeAccessTokenUseCase.class);
    private final TokenPort tokenPort;

    public RevokeAccessTokenUseCase(TokenPort tokenPort) {
        this.tokenPort = Objects.requireNonNull(tokenPort, "Token port cannot be null");
    }

    public CompletableFuture<RevokeTokenResult> execute(String tokenId) {
        Objects.requireNonNull(tokenId, "Token ID cannot be null");
        LOGGER.info("revoke_token_started token_id={}", (Object)tokenId);
        return ((CompletableFuture)((CompletableFuture)this.tokenPort.getToken(tokenId).thenCompose(optionalToken -> {
            if (optionalToken.isEmpty()) {
                LOGGER.warn("revoke_token_rejected token_id={} reason=not_found", (Object)tokenId);
                return CompletableFuture.completedFuture(RevokeTokenResult.notFound(tokenId));
            }
            AccessToken token = (AccessToken)optionalToken.get();
            String keyName = token.getKeyName();
            String clientName = token.getClientName();
            if (token.isRevoked()) {
                LOGGER.info("revoke_token_skipped token_id={} reason=already_revoked", (Object)tokenId);
                return CompletableFuture.completedFuture(RevokeTokenResult.alreadyRevoked(tokenId, keyName, clientName));
            }
            return this.tokenPort.revokeToken(tokenId).thenApply(revoked -> {
                if (revoked.booleanValue()) {
                    return RevokeTokenResult.success(tokenId, keyName, clientName);
                }
                return RevokeTokenResult.failure(tokenId, "Token revocation returned false. Token may have already been revoked.");
            });
        })).whenComplete((result, error) -> {
            if (error != null) {
                LOGGER.error("revoke_token_failed token_id={} error={}", new Object[]{tokenId, error.getMessage(), error});
            } else if (result.success()) {
                LOGGER.info("revoke_token_complete token_id={} key_name={} client_name={}", new Object[]{tokenId, result.keyName(), result.clientName()});
            }
        })).exceptionally(error -> RevokeTokenResult.failure(tokenId, error.getMessage()));
    }

    public CompletableFuture<BulkRevokeResult> revokeAllForKey(String keyName) {
        Objects.requireNonNull(keyName, "Key name cannot be null");
        LOGGER.info("revoke_all_tokens_started key_name={}", (Object)keyName);
        return ((CompletableFuture)this.tokenPort.listTokens(keyName).thenCompose(tokens -> {
            List<AccessToken> activeTokens = tokens.stream().filter(t -> !t.isRevoked()).toList();
            if (activeTokens.isEmpty()) {
                return CompletableFuture.completedFuture(new BulkRevokeResult(keyName, 0, 0, null));
            }
            List<CompletableFuture> futures = activeTokens.stream().map(t -> this.tokenPort.revokeToken(t.getId()).exceptionally(e -> false)).toList();
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> {
                long successCount = futures.stream().map(CompletableFuture::join).filter(Boolean::booleanValue).count();
                return new BulkRevokeResult(keyName, activeTokens.size(), (int)successCount, null);
            });
        })).whenComplete((result, error) -> {
            if (error != null) {
                LOGGER.error("revoke_all_tokens_failed key_name={} error={}", new Object[]{keyName, error.getMessage(), error});
            } else {
                LOGGER.info("revoke_all_tokens_complete key_name={} attempted={} revoked={}", new Object[]{keyName, result.attempted(), result.revoked()});
            }
        });
    }

    public record BulkRevokeResult(String keyName, int attempted, int revoked, String error) {
        public boolean isFullSuccess() {
            return this.error == null && this.attempted == this.revoked;
        }

        public boolean isPartialSuccess() {
            return this.revoked > 0 && this.revoked < this.attempted;
        }
    }

    public record RevokeTokenResult(boolean success, String tokenId, String keyName, String clientName, String errorMessage, boolean alreadyRevoked) {
        public static RevokeTokenResult success(String tokenId, String keyName, String clientName) {
            return new RevokeTokenResult(true, tokenId, keyName, clientName, null, false);
        }

        public static RevokeTokenResult notFound(String tokenId) {
            return new RevokeTokenResult(false, tokenId, null, null, "Token not found: " + tokenId, false);
        }

        public static RevokeTokenResult alreadyRevoked(String tokenId, String keyName, String clientName) {
            return new RevokeTokenResult(true, tokenId, keyName, clientName, "Token was already revoked", true);
        }

        public static RevokeTokenResult failure(String tokenId, String errorMessage) {
            return new RevokeTokenResult(false, tokenId, null, null, errorMessage, false);
        }

        public boolean isNotFound() {
            return !this.success && this.errorMessage != null && this.errorMessage.contains("not found");
        }
    }
}

