/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_20_0;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

final class BigSignificand {
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private final int numInts;
    private final int[] x;
    private int firstNonZeroInt;

    public BigSignificand(long numBits) {
        if (numBits <= 0L || numBits >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("numBits=" + numBits);
        }
        int numLongs = (int)(numBits + 63L >>> 6) + 1;
        this.numInts = numLongs << 1;
        this.x = new int[this.numInts];
        this.firstNonZeroInt = this.numInts;
    }

    public void add(int value) {
        if (value == 0) {
            return;
        }
        long carry = (long)value & 0xFFFFFFFFL;
        int i2 = this.numInts - 1;
        while (carry != 0L) {
            long sum = ((long)this.x(i2) & 0xFFFFFFFFL) + carry;
            this.x(i2, (int)sum);
            carry = sum >>> 32;
            --i2;
        }
        this.firstNonZeroInt = Math.min(this.firstNonZeroInt, i2 + 1);
    }

    public void fma(int factor, int addend) {
        int i2;
        long factorL = (long)factor & 0xFFFFFFFFL;
        long carry = addend;
        for (i2 = this.numInts - 1; i2 >= this.firstNonZeroInt; --i2) {
            long product = factorL * ((long)this.x(i2) & 0xFFFFFFFFL) + carry;
            this.x(i2, (int)product);
            carry = product >>> 32;
        }
        if (carry != 0L) {
            this.x(i2, (int)carry);
            this.firstNonZeroInt = i2;
        }
    }

    public BigInteger toBigInteger() {
        byte[] bytes = new byte[this.x.length << 2];
        IntBuffer buf = ByteBuffer.wrap(bytes).asIntBuffer();
        for (int i2 = 0; i2 < this.x.length; ++i2) {
            buf.put(i2, this.x[i2]);
        }
        return new BigInteger(bytes);
    }

    private void x(int i2, int value) {
        this.x[i2] = value;
    }

    private int x(int i2) {
        return this.x[i2];
    }
}

