/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP01;
import nostr.api.NIP12;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.base.Marker;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.base.json.EventJsonMapper;
import nostr.event.entities.ChannelProfile;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;
import org.apache.commons.text.StringEscapeUtils;

public class NIP28
extends EventNostr {
    public NIP28(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP28 createChannelCreateEvent(@NonNull ChannelProfile profile2) {
        if (profile2 == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.CHANNEL_CREATE.getValue(), StringEscapeUtils.escapeJson(profile2.toString())).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP28 createChannelMessageEvent(@NonNull GenericEvent channelCreateEvent, GenericEvent messageReplyTo, Relay recommendedRelayRoot, Relay recommendedRelayReply, @NonNull String content) {
        if (channelCreateEvent == null) {
            throw new NullPointerException("channelCreateEvent is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (channelCreateEvent.getKind().intValue() != Kind.CHANNEL_CREATE.getValue()) {
            throw new IllegalArgumentException("The event is not a channel creation event");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.CHANNEL_MESSAGE.getValue(), content).create();
        genericEvent.addTag(NIP01.createEventTag(channelCreateEvent.getId(), recommendedRelayRoot, Marker.ROOT));
        if (messageReplyTo != null) {
            genericEvent.addTag(NIP01.createEventTag(messageReplyTo.getId(), recommendedRelayReply, Marker.REPLY));
            genericEvent.addTag(NIP01.createPubKeyTag(messageReplyTo.getPubKey()));
        }
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP28 createChannelMessageEvent(@NonNull GenericEvent channelCreateEvent, @NonNull Relay recommendedRelayRoot, @NonNull String content) {
        if (channelCreateEvent == null) {
            throw new NullPointerException("channelCreateEvent is marked non-null but is null");
        }
        if (recommendedRelayRoot == null) {
            throw new NullPointerException("recommendedRelayRoot is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return this.createChannelMessageEvent(channelCreateEvent, null, recommendedRelayRoot, null, content);
    }

    public NIP28 createChannelMessageEvent(@NonNull GenericEvent channelCreateEvent, @NonNull GenericEvent eventTagReplyTo, @NonNull String content) {
        if (channelCreateEvent == null) {
            throw new NullPointerException("channelCreateEvent is marked non-null but is null");
        }
        if (eventTagReplyTo == null) {
            throw new NullPointerException("eventTagReplyTo is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return this.createChannelMessageEvent(channelCreateEvent, eventTagReplyTo, null, null, content);
    }

    public NIP28 updateChannelMetadataEvent(@NonNull GenericEvent channelCreateEvent, @NonNull ChannelProfile profile2, Relay relay) {
        if (channelCreateEvent == null) {
            throw new NullPointerException("channelCreateEvent is marked non-null but is null");
        }
        if (profile2 == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        return this.updateChannelMetadataEvent(channelCreateEvent, profile2, null, relay);
    }

    public NIP28 updateChannelMetadataEvent(@NonNull GenericEvent channelCreateEvent, @NonNull ChannelProfile profile2, List<String> categories, Relay relay) {
        if (channelCreateEvent == null) {
            throw new NullPointerException("channelCreateEvent is marked non-null but is null");
        }
        if (profile2 == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        if (channelCreateEvent.getKind().intValue() != Kind.CHANNEL_CREATE.getValue()) {
            throw new IllegalArgumentException("The event is not a channel creation event");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.CHANNEL_METADATA.getValue(), StringEscapeUtils.escapeJson(profile2.toString())).create();
        genericEvent.addTag(NIP01.createEventTag(channelCreateEvent.getId(), relay, Marker.ROOT));
        if (categories != null) {
            categories.stream().filter(category -> category != null && !category.isEmpty()).forEach(category -> genericEvent.addTag(NIP12.createHashtagTag(category)));
        }
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP28 createHideMessageEvent(@NonNull GenericEvent channelMessageEvent, String reason) {
        if (channelMessageEvent == null) {
            throw new NullPointerException("channelMessageEvent is marked non-null but is null");
        }
        if (channelMessageEvent.getKind().intValue() != Kind.CHANNEL_MESSAGE.getValue()) {
            throw new IllegalArgumentException("The event is not a channel message event");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.HIDE_MESSAGE.getValue(), Reason.fromString(reason).toString()).create();
        genericEvent.addTag(NIP01.createEventTag(channelMessageEvent.getId()));
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP28 createMuteUserEvent(@NonNull PublicKey mutedUser, String reason) {
        if (mutedUser == null) {
            throw new NullPointerException("mutedUser is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.MUTE_USER.getValue(), Reason.fromString(reason).toString()).create();
        genericEvent.addTag(NIP01.createPubKeyTag(mutedUser));
        this.updateEvent(genericEvent);
        return this;
    }

    private static class Reason {
        @JsonProperty(value="reason")
        private String value;

        public String toString() {
            try {
                return EventJsonMapper.mapper().writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        public static Reason fromString(String reason) {
            return new Reason(reason);
        }

        @Generated
        public Reason() {
        }

        @Generated
        public Reason(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reason)) {
                return false;
            }
            Reason other = (Reason)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.value;
            String other$value = other.value;
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Reason;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.value;
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }
    }
}

