/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.NoSuchElementException;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.base.PublicKey;
import nostr.encryption.MessageCipher44;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.PubKeyTag;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIP44
extends EventNostr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NIP44.class);

    public static String encrypt(@NonNull Identity sender, @NonNull String message, @NonNull PublicKey recipient) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        MessageCipher44 cipher = new MessageCipher44(sender.getPrivateKey().getRawData(), recipient.getRawData());
        return cipher.encrypt(message);
    }

    public static String decrypt(@NonNull Identity identity, @NonNull String encrypteEPessage, @NonNull PublicKey recipient) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (encrypteEPessage == null) {
            throw new NullPointerException("encrypteEPessage is marked non-null but is null");
        }
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        MessageCipher44 cipher = new MessageCipher44(identity.getPrivateKey().getRawData(), recipient.getRawData());
        return cipher.decrypt(encrypteEPessage);
    }

    public static String decrypt(@NonNull Identity recipient, @NonNull GenericEvent event) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        boolean rcptFlag = NIP44.amITheRecipient(recipient, event);
        if (!rcptFlag) {
            MessageCipher44 cipher = new MessageCipher44(recipient.getPrivateKey().getRawData(), ((PubKeyTag)Filterable.getTypeSpecificTags(PubKeyTag.class, event).stream().findFirst().orElseThrow(() -> new NoSuchElementException("No matching p-tag found."))).getPublicKey().getRawData());
            return cipher.decrypt(event.getContent());
        }
        PublicKey sender = event.getPubKey();
        log.debug("Decrypting message for {}", (Object)sender);
        MessageCipher44 cipher = new MessageCipher44(recipient.getPrivateKey().getRawData(), sender.getRawData());
        return cipher.decrypt(event.getContent());
    }

    private static boolean amITheRecipient(@NonNull Identity recipient, @NonNull GenericEvent event) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        PubKeyTag pTag = (PubKeyTag)Filterable.getTypeSpecificTags(PubKeyTag.class, event).stream().findFirst().orElseThrow(() -> new NoSuchElementException("No matching p-tag found."));
        if (Objects.equals(recipient.getPublicKey(), pTag.getPublicKey())) {
            return true;
        }
        if (Objects.equals(recipient.getPublicKey(), event.getPubKey())) {
            return false;
        }
        throw new RuntimeException("Unrelated event");
    }
}

