/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP01;
import nostr.api.NIP23;
import nostr.api.NIP99;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.event.BaseTag;
import nostr.event.entities.CalendarContent;
import nostr.event.entities.CalendarRsvpContent;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.EventTag;
import nostr.event.tag.GeohashTag;
import nostr.id.Identity;
import org.apache.commons.lang3.stream.Streams;

public class NIP52
extends EventNostr {
    public NIP52(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP52 createCalendarTimeBasedEvent(@NonNull List<BaseTag> baseTags, @NonNull String content, @NonNull CalendarContent<BaseTag> calendarContent) {
        if (baseTags == null) {
            throw new NullPointerException("baseTags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (calendarContent == null) {
            throw new NullPointerException("calendarContent is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory<BaseTag>(this.getSender(), Kind.CALENDAR_TIME_BASED_EVENT.getValue(), baseTags, content).create();
        genericEvent.addTag(calendarContent.getIdentifierTag());
        genericEvent.addTag(NIP23.createTitleTag(calendarContent.getTitle()));
        genericEvent.addTag(NIP52.createStartTag(calendarContent.getStart()));
        Optional<GeohashTag> geohashTag = calendarContent.getGeohashTag();
        geohashTag.ifPresent(genericEvent::addTag);
        calendarContent.getEnd().ifPresent(aLong -> genericEvent.addTag(NIP52.createEndTag(aLong)));
        calendarContent.getStartTzid().ifPresent(s -> genericEvent.addTag(NIP52.createStartTzidTag(s)));
        calendarContent.getEndTzid().ifPresent(s -> genericEvent.addTag(NIP52.createEndTzidTag(s)));
        calendarContent.getSummary().ifPresent(s -> genericEvent.addTag(NIP23.createSummaryTag(s)));
        calendarContent.getImage().ifPresent(s -> genericEvent.addTag(NIP23.createImageTag(Streams.failableStream(URI.create(s)).map(URI::toURL).stream().findFirst().orElseThrow())));
        calendarContent.getParticipantPubKeyTags().forEach(genericEvent::addTag);
        calendarContent.getLocation().ifPresent(s -> genericEvent.addTag(NIP99.createLocationTag(s)));
        calendarContent.getHashtagTags().forEach(genericEvent::addTag);
        calendarContent.getReferenceTags().forEach(genericEvent::addTag);
        calendarContent.getLabelTags().forEach(genericEvent::addTag);
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP52 createCalendarRsvpEvent(@NonNull String content, @NonNull CalendarRsvpContent calendarRsvpContent) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (calendarRsvpContent == null) {
            throw new NullPointerException("calendarRsvpContent is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.CALENDAR_RSVP_EVENT.getValue(), content).create();
        genericEvent.addTag(calendarRsvpContent.getIdentifierTag());
        genericEvent.addTag(calendarRsvpContent.getAddressTag());
        genericEvent.addTag(NIP99.createStatusTag(calendarRsvpContent.getStatus()));
        calendarRsvpContent.getAuthorPubKeyTag().ifPresent(genericEvent::addTag);
        calendarRsvpContent.getEventTag().ifPresent(genericEvent::addTag);
        calendarRsvpContent.getFbTag().ifPresent(genericEvent::addTag);
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP52 createDateBasedCalendarEvent(@NonNull String content, @NonNull CalendarContent<BaseTag> calendarContent) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (calendarContent == null) {
            throw new NullPointerException("calendarContent is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.CALENDAR_DATE_BASED_EVENT.getValue(), content).create();
        genericEvent.addTag(calendarContent.getIdentifierTag());
        genericEvent.addTag(NIP23.createTitleTag(calendarContent.getTitle()));
        genericEvent.addTag(NIP52.createStartTag(calendarContent.getStart()));
        calendarContent.getGeohashTag().ifPresent(genericEvent::addTag);
        calendarContent.getEnd().ifPresent(s -> genericEvent.addTag(NIP52.createEndTag(s)));
        calendarContent.getStartTzid().ifPresent(s -> genericEvent.addTag(NIP52.createStartTzidTag(s)));
        calendarContent.getEndTzid().ifPresent(s -> genericEvent.addTag(NIP52.createEndTzidTag(s)));
        calendarContent.getSummary().ifPresent(s -> genericEvent.addTag(NIP23.createSummaryTag(s)));
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP52 addIdentifierTag(@NonNull String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        this.addTag(NIP01.createIdentifierTag(identifier));
        return this;
    }

    public NIP52 addTitleTag(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.addTag(NIP23.createTitleTag(title));
        return this;
    }

    public NIP52 addStartTag(@NonNull Long start) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        this.addTag(NIP52.createStartTag(start));
        return this;
    }

    public NIP52 addEndTag(@NonNull Long end) {
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        this.addTag(NIP52.createEndTag(end));
        return this;
    }

    public NIP52 addEventTag(@NonNull EventTag eventTag) {
        if (eventTag == null) {
            throw new NullPointerException("eventTag is marked non-null but is null");
        }
        this.addTag(eventTag);
        return this;
    }

    public static BaseTag createStartTag(@NonNull Long start) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        return new BaseTagFactory("start", start.toString()).create();
    }

    public static BaseTag createEndTag(@NonNull Long end) {
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        return new BaseTagFactory("end", end.toString()).create();
    }

    public static BaseTag createStartTzidTag(@NonNull String startTzid) {
        if (startTzid == null) {
            throw new NullPointerException("startTzid is marked non-null but is null");
        }
        return new BaseTagFactory("start_tzid", startTzid).create();
    }

    public static BaseTag createEndTzidTag(@NonNull String endTzid) {
        if (endTzid == null) {
            throw new NullPointerException("endTzid is marked non-null but is null");
        }
        return new BaseTagFactory("end_tzid", endTzid).create();
    }

    public static BaseTag createFreeBusyTag(@NonNull String fb) {
        if (fb == null) {
            throw new NullPointerException("fb is marked non-null but is null");
        }
        return new BaseTagFactory("fb", fb).create();
    }
}

