/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.net.URL;
import java.util.List;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP12;
import nostr.api.NIP23;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.event.BaseTag;
import nostr.event.entities.ClassifiedListing;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;

public class NIP99
extends EventNostr {
    public NIP99(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP99 createClassifiedListingEvent(@NonNull List<BaseTag> baseTags, String content, @NonNull ClassifiedListing classifiedListing) {
        if (baseTags == null) {
            throw new NullPointerException("baseTags is marked non-null but is null");
        }
        if (classifiedListing == null) {
            throw new NullPointerException("classifiedListing is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory<BaseTag>(this.getSender(), Kind.CLASSIFIED_LISTING.getValue(), baseTags, content).create();
        genericEvent.addTag(NIP23.createTitleTag(classifiedListing.getTitle()));
        genericEvent.addTag(NIP23.createSummaryTag(classifiedListing.getSummary()));
        if (classifiedListing.getPublishedAt() != null) {
            genericEvent.addTag(NIP23.createPublishedAtTag(classifiedListing.getPublishedAt()));
        }
        if (classifiedListing.getLocation() != null) {
            genericEvent.addTag(NIP99.createLocationTag(classifiedListing.getLocation()));
        }
        genericEvent.addTag(classifiedListing.getPriceTag());
        this.updateEvent(genericEvent);
        return this;
    }

    public static BaseTag createLocationTag(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return new BaseTagFactory("location", location).create();
    }

    public static BaseTag createPriceTag(@NonNull String price, @NonNull String currency) {
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        return new BaseTagFactory("price", price, currency, null).create();
    }

    public static BaseTag createPriceTag(@NonNull String price, @NonNull String currency, String frequency) {
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        return new BaseTagFactory("price", price, currency, frequency).create();
    }

    public static BaseTag createStatusTag(@NonNull String status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        return new BaseTagFactory("status", status).create();
    }

    public NIP99 addHashtagTag(@NonNull String hashtag) {
        if (hashtag == null) {
            throw new NullPointerException("hashtag is marked non-null but is null");
        }
        this.getEvent().addTag(NIP12.createHashtagTag(hashtag));
        return this;
    }

    public NIP99 addLocationTag(@NonNull String location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        this.getEvent().addTag(NIP99.createLocationTag(location));
        return this;
    }

    public NIP99 addGeohashTag(@NonNull String geohash) {
        if (geohash == null) {
            throw new NullPointerException("geohash is marked non-null but is null");
        }
        this.getEvent().addTag(NIP12.createGeohashTag(geohash));
        return this;
    }

    public NIP99 addPriceTag(@NonNull String price, @NonNull String currency, String frequency) {
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        this.getEvent().addTag(NIP99.createPriceTag(price, currency, frequency));
        return this;
    }

    public NIP99 addPriceTag(@NonNull String price, @NonNull String currency) {
        if (price == null) {
            throw new NullPointerException("price is marked non-null but is null");
        }
        if (currency == null) {
            throw new NullPointerException("currency is marked non-null but is null");
        }
        return this.addPriceTag(price, currency, null);
    }

    public NIP99 addTitleTag(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.getEvent().addTag(NIP23.createTitleTag(title));
        return this;
    }

    public NIP99 addSummaryTag(@NonNull String summary) {
        if (summary == null) {
            throw new NullPointerException("summary is marked non-null but is null");
        }
        this.getEvent().addTag(NIP23.createSummaryTag(summary));
        return this;
    }

    public NIP99 addPublishedAtTag(@NonNull Long date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.getEvent().addTag(NIP23.createPublishedAtTag(date));
        return this;
    }

    public NIP99 addImageTag(@NonNull URL url, String size) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.getEvent().addTag(NIP23.createImageTag(url, size));
        return this;
    }

    public NIP99 addStatusTag(@NonNull String status) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        this.getEvent().addTag(NIP99.createStatusTag(status));
        return this;
    }

    @Override
    public NIP99 addTag(@NonNull BaseTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.getEvent().addTag(tag);
        return this;
    }
}

