/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.client;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import lombok.NonNull;
import nostr.api.client.NostrRelayRegistry;
import nostr.api.service.NoteService;
import nostr.base.IEvent;
import nostr.crypto.schnorr.Schnorr;
import nostr.crypto.schnorr.SchnorrException;
import nostr.event.impl.GenericEvent;
import nostr.util.NostrUtil;

public final class NostrEventDispatcher {
    private final NoteService noteService;
    private final NostrRelayRegistry relayRegistry;

    public NostrEventDispatcher(NoteService noteService, NostrRelayRegistry relayRegistry) {
        this.noteService = noteService;
        this.relayRegistry = relayRegistry;
    }

    public List<String> send(@NonNull IEvent event) {
        GenericEvent genericEvent;
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event instanceof GenericEvent && !this.verify(genericEvent = (GenericEvent)event)) {
            throw new IllegalStateException("Event verification failed");
        }
        return this.noteService.send(event, this.relayRegistry.getClientMap());
    }

    public boolean verify(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (!event.isSigned()) {
            throw new IllegalStateException("The event is not signed");
        }
        try {
            return Schnorr.verify(NostrUtil.sha256(event.getSerializedEventCache()), event.getPubKey().getRawData(), event.getSignature().getRawData());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 algorithm not available", e);
        }
        catch (SchnorrException e) {
            throw new IllegalStateException("Failed to verify Schnorr signature", e);
        }
    }
}

