/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import nostr.api.WebSocketClientHandler;
import nostr.api.client.WebSocketClientHandlerFactory;
import nostr.base.RelayUri;
import nostr.base.SubscriptionId;

public class NostrRelayRegistry {
    private final Map<String, WebSocketClientHandler> clientMap = new ConcurrentHashMap<String, WebSocketClientHandler>();
    private final WebSocketClientHandlerFactory factory;

    public NostrRelayRegistry(WebSocketClientHandlerFactory factory2) {
        this.factory = factory2;
    }

    public Map<String, WebSocketClientHandler> getClientMap() {
        return this.clientMap;
    }

    public void registerRelays(Map<String, String> relays) {
        for (Map.Entry<String, String> relayEntry : relays.entrySet()) {
            this.clientMap.computeIfAbsent(relayEntry.getKey(), key -> this.createHandler((String)key, new RelayUri((String)relayEntry.getValue())));
        }
    }

    public Map<String, String> snapshotRelays() {
        return this.clientMap.values().stream().collect(Collectors.toMap(WebSocketClientHandler::getRelayName, handler -> handler.getRelayUri().toString(), (prev, next) -> next, HashMap::new));
    }

    public List<WebSocketClientHandler> baseHandlers() {
        return this.clientMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).contains(":")).map(Map.Entry::getValue).toList();
    }

    public List<WebSocketClientHandler> requestHandlers(SubscriptionId subscriptionId) {
        return this.clientMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith(":" + subscriptionId.value())).map(Map.Entry::getValue).toList();
    }

    public void ensureRequestClients(SubscriptionId subscriptionId) {
        for (WebSocketClientHandler baseHandler : this.baseHandlers()) {
            this.clientMap.computeIfAbsent(baseHandler.getRelayName() + ":" + subscriptionId.value(), key -> this.createHandler((String)key, baseHandler.getRelayUri()));
        }
    }

    public void closeAll() throws IOException {
        for (WebSocketClientHandler client : this.clientMap.values()) {
            client.close();
        }
    }

    private WebSocketClientHandler createHandler(String relayName, RelayUri relayUri) {
        try {
            return this.factory.create(relayName, relayUri);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Failed to initialize WebSocket client handler", e);
        }
    }
}

