/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.nip01;

import java.util.List;
import lombok.NonNull;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PubKeyTag;
import nostr.id.Identity;

public final class NIP01EventBuilder {
    private Identity defaultSender;

    public NIP01EventBuilder(Identity defaultSender) {
        this.defaultSender = defaultSender;
    }

    public void updateDefaultSender(Identity defaultSender) {
        this.defaultSender = defaultSender;
    }

    public GenericEvent buildTextNote(String content) {
        return new GenericEventFactory(this.resolveSender(null), Kind.TEXT_NOTE.getValue(), content).create();
    }

    public GenericEvent buildRecipientTextNote(String content, List<PubKeyTag> tags) {
        return new GenericEventFactory<PubKeyTag>(this.resolveSender(null), Kind.TEXT_NOTE.getValue(), tags, content).create();
    }

    public GenericEvent buildTaggedTextNote(@NonNull List<BaseTag> tags, @NonNull String content) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return new GenericEventFactory<BaseTag>(this.resolveSender(null), Kind.TEXT_NOTE.getValue(), tags, content).create();
    }

    public GenericEvent buildMetadataEvent(@NonNull Identity sender, @NonNull String payload) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        return new GenericEventFactory(this.resolveSender(sender), Kind.SET_METADATA.getValue(), payload).create();
    }

    public GenericEvent buildMetadataEvent(@NonNull String payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        Identity sender = this.resolveSender(null);
        if (sender != null) {
            return this.buildMetadataEvent(sender, payload);
        }
        return new GenericEventFactory(Kind.SET_METADATA.getValue(), payload).create();
    }

    public GenericEvent buildReplaceableEvent(Integer kind, String content) {
        return new GenericEventFactory(this.resolveSender(null), kind, content).create();
    }

    public GenericEvent buildReplaceableEvent(List<BaseTag> tags, Integer kind, String content) {
        return new GenericEventFactory<BaseTag>(this.resolveSender(null), kind, tags, content).create();
    }

    public GenericEvent buildEphemeralEvent(List<BaseTag> tags, Integer kind, String content) {
        return new GenericEventFactory<BaseTag>(this.resolveSender(null), kind, tags, content).create();
    }

    public GenericEvent buildEphemeralEvent(Integer kind, String content) {
        return new GenericEventFactory(this.resolveSender(null), kind, content).create();
    }

    public GenericEvent buildAddressableEvent(Integer kind, String content) {
        return new GenericEventFactory(this.resolveSender(null), kind, content).create();
    }

    public GenericEvent buildAddressableEvent(@NonNull List<GenericTag> tags, @NonNull Integer kind, String content) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        return new GenericEventFactory<GenericTag>(this.resolveSender(null), kind, tags, content).create();
    }

    private Identity resolveSender(Identity override) {
        return override != null ? override : this.defaultSender;
    }
}

