/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.nip01;

import java.util.List;
import lombok.NonNull;
import nostr.event.filter.Filters;
import nostr.event.impl.GenericEvent;
import nostr.event.message.CloseMessage;
import nostr.event.message.EoseMessage;
import nostr.event.message.EventMessage;
import nostr.event.message.NoticeMessage;
import nostr.event.message.ReqMessage;

public final class NIP01MessageFactory {
    private NIP01MessageFactory() {
    }

    public static EventMessage eventMessage(@NonNull GenericEvent event, String subscriptionId) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return subscriptionId != null ? new EventMessage(event, subscriptionId) : new EventMessage(event);
    }

    public static ReqMessage reqMessage(@NonNull String subscriptionId, @NonNull List<Filters> filters) {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        return new ReqMessage(subscriptionId, filters);
    }

    public static CloseMessage closeMessage(@NonNull String subscriptionId) {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return new CloseMessage(subscriptionId);
    }

    public static EoseMessage eoseMessage(@NonNull String subscriptionId) {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return new EoseMessage(subscriptionId);
    }

    public static NoticeMessage noticeMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return new NoticeMessage(message);
    }
}

