/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.nip57;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.security.NoSuchAlgorithmException;
import lombok.NonNull;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.api.nip01.NIP01TagFactory;
import nostr.api.nip57.Bolt11Util;
import nostr.api.nip57.NIP57TagFactory;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.json.EventJsonMapper;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.json.codec.EventEncodingException;
import nostr.event.tag.AddressTag;
import nostr.event.tag.GenericTag;
import nostr.id.Identity;
import nostr.util.NostrUtil;
import org.apache.commons.text.StringEscapeUtils;

public final class NIP57ZapReceiptBuilder {
    private Identity defaultSender;

    public NIP57ZapReceiptBuilder(Identity defaultSender) {
        this.defaultSender = defaultSender;
    }

    public void updateDefaultSender(Identity defaultSender) {
        this.defaultSender = defaultSender;
    }

    public GenericEvent build(@NonNull GenericEvent zapRequestEvent, @NonNull String bolt11, @NonNull String preimage, @NonNull PublicKey zapRecipient) {
        GenericEvent receipt;
        block10: {
            if (zapRequestEvent == null) {
                throw new NullPointerException("zapRequestEvent is marked non-null but is null");
            }
            if (bolt11 == null) {
                throw new NullPointerException("bolt11 is marked non-null but is null");
            }
            if (preimage == null) {
                throw new NullPointerException("preimage is marked non-null but is null");
            }
            if (zapRecipient == null) {
                throw new NullPointerException("zapRecipient is marked non-null but is null");
            }
            receipt = new GenericEventFactory(this.resolveSender(null), Kind.ZAP_RECEIPT.getValue(), "").create();
            receipt.addTag(NIP01TagFactory.pubKeyTag(zapRecipient));
            try {
                String description = EventJsonMapper.mapper().writeValueAsString(zapRequestEvent);
                receipt.addTag(NIP57TagFactory.description(StringEscapeUtils.escapeJson(description)));
                String hash = NostrUtil.bytesToHex(NostrUtil.sha256(description.getBytes()));
                receipt.addTag(NIP57TagFactory.descriptionHash(hash));
            }
            catch (JsonProcessingException ex) {
                throw new EventEncodingException("Failed to encode zap receipt description", ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IllegalStateException("SHA-256 algorithm not available", ex);
            }
            receipt.addTag(NIP57TagFactory.bolt11(bolt11));
            receipt.addTag(NIP57TagFactory.preimage(preimage));
            receipt.addTag(NIP57TagFactory.zapSender(zapRequestEvent.getPubKey()));
            receipt.addTag(NIP01TagFactory.eventTag(zapRequestEvent.getId()));
            Filterable.getTypeSpecificTags(AddressTag.class, zapRequestEvent).stream().findFirst().ifPresent(receipt::addTag);
            try {
                GenericTag amountTag;
                String amountStr;
                long requestedMsat;
                long invoiceMsat = Bolt11Util.parseMsat(bolt11);
                if (invoiceMsat >= 0L && (requestedMsat = Long.parseLong(amountStr = (amountTag = Filterable.requireTagOfTypeWithCode(GenericTag.class, "amount", zapRequestEvent)).getAttributes().get(0).value().toString())) != invoiceMsat) {
                    throw new IllegalArgumentException("Invoice amount does not match zap request amount: requested=" + requestedMsat + " msat, invoice=" + invoiceMsat + " msat");
                }
            }
            catch (RuntimeException ex) {
                if (!(ex instanceof IllegalArgumentException)) break block10;
                throw ex;
            }
        }
        receipt.setCreatedAt(zapRequestEvent.getCreatedAt());
        return receipt;
    }

    private Identity resolveSender(Identity override) {
        Identity resolved;
        Identity identity = resolved = override != null ? override : this.defaultSender;
        if (resolved == null) {
            throw new IllegalStateException("Sender identity is required to build zap receipts");
        }
        return resolved;
    }
}

