/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.nip57;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.RelaysTag;
import nostr.id.Identity;

public final class ZapRequestParameters {
    private final Identity sender;
    @NonNull
    private final Long amount;
    @NonNull
    private final String lnUrl;
    private final String content;
    private final BaseTag addressTag;
    private final GenericEvent zappedEvent;
    private final PublicKey recipientPubKey;
    private final RelaysTag relaysTag;
    private final List<Relay> relays;

    public String contentOrDefault() {
        return this.content != null ? this.content : "";
    }

    public RelaysTag determineRelaysTag() {
        if (this.relaysTag != null) {
            return this.relaysTag;
        }
        if (this.relays != null && !this.relays.isEmpty()) {
            return new RelaysTag(this.relays);
        }
        throw new IllegalStateException("A relays tag or relay list is required to build zap requests");
    }

    @Generated
    ZapRequestParameters(Identity sender, @NonNull Long amount, @NonNull String lnUrl, String content, BaseTag addressTag, GenericEvent zappedEvent, PublicKey recipientPubKey, RelaysTag relaysTag, List<Relay> relays) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (lnUrl == null) {
            throw new NullPointerException("lnUrl is marked non-null but is null");
        }
        this.sender = sender;
        this.amount = amount;
        this.lnUrl = lnUrl;
        this.content = content;
        this.addressTag = addressTag;
        this.zappedEvent = zappedEvent;
        this.recipientPubKey = recipientPubKey;
        this.relaysTag = relaysTag;
        this.relays = relays;
    }

    @Generated
    public static ZapRequestParametersBuilder builder() {
        return new ZapRequestParametersBuilder();
    }

    @Generated
    public Identity getSender() {
        return this.sender;
    }

    @NonNull
    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public String getLnUrl() {
        return this.lnUrl;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public BaseTag getAddressTag() {
        return this.addressTag;
    }

    @Generated
    public GenericEvent getZappedEvent() {
        return this.zappedEvent;
    }

    @Generated
    public PublicKey getRecipientPubKey() {
        return this.recipientPubKey;
    }

    @Generated
    public RelaysTag getRelaysTag() {
        return this.relaysTag;
    }

    @Generated
    public List<Relay> getRelays() {
        return this.relays;
    }

    @Generated
    public static class ZapRequestParametersBuilder {
        @Generated
        private Identity sender;
        @Generated
        private Long amount;
        @Generated
        private String lnUrl;
        @Generated
        private String content;
        @Generated
        private BaseTag addressTag;
        @Generated
        private GenericEvent zappedEvent;
        @Generated
        private PublicKey recipientPubKey;
        @Generated
        private RelaysTag relaysTag;
        @Generated
        private ArrayList<Relay> relays;

        @Generated
        ZapRequestParametersBuilder() {
        }

        @Generated
        public ZapRequestParametersBuilder sender(Identity sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder amount(@NonNull Long amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder lnUrl(@NonNull String lnUrl) {
            if (lnUrl == null) {
                throw new NullPointerException("lnUrl is marked non-null but is null");
            }
            this.lnUrl = lnUrl;
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder content(String content) {
            this.content = content;
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder addressTag(BaseTag addressTag) {
            this.addressTag = addressTag;
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder zappedEvent(GenericEvent zappedEvent) {
            this.zappedEvent = zappedEvent;
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder recipientPubKey(PublicKey recipientPubKey) {
            this.recipientPubKey = recipientPubKey;
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder relaysTag(RelaysTag relaysTag) {
            this.relaysTag = relaysTag;
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder relay(Relay relay) {
            if (this.relays == null) {
                this.relays = new ArrayList();
            }
            this.relays.add(relay);
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder relays(Collection<? extends Relay> relays) {
            if (relays == null) {
                throw new NullPointerException("relays cannot be null");
            }
            if (this.relays == null) {
                this.relays = new ArrayList();
            }
            this.relays.addAll(relays);
            return this;
        }

        @Generated
        public ZapRequestParametersBuilder clearRelays() {
            if (this.relays != null) {
                this.relays.clear();
            }
            return this;
        }

        @Generated
        public ZapRequestParameters build() {
            return new ZapRequestParameters(this.sender, this.amount, this.lnUrl, this.content, this.addressTag, this.zappedEvent, this.recipientPubKey, this.relaysTag, switch (this.relays == null ? 0 : this.relays.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.relays.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Relay>(this.relays));
            });
        }

        @Generated
        public String toString() {
            return "ZapRequestParameters.ZapRequestParametersBuilder(sender=" + String.valueOf(this.sender) + ", amount=" + this.amount + ", lnUrl=" + this.lnUrl + ", content=" + this.content + ", addressTag=" + String.valueOf(this.addressTag) + ", zappedEvent=" + String.valueOf(this.zappedEvent) + ", recipientPubKey=" + String.valueOf(this.recipientPubKey) + ", relaysTag=" + String.valueOf(this.relaysTag) + ", relays=" + String.valueOf(this.relays) + ")";
        }
    }
}

