/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.entities;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuProof;
import nostr.event.json.serializer.CashuTokenSerializer;

@JsonSerialize(using=CashuTokenSerializer.class)
public class CashuToken {
    private CashuMint mint;
    private List<CashuProof> proofs;
    private List<String> destroyed;

    public CashuToken() {
        this.proofs = new ArrayList<CashuProof>();
        this.destroyed = new ArrayList<String>();
    }

    public CashuToken(@NonNull CashuMint mint, @NonNull List<CashuProof> proofs) {
        this(mint, proofs, new ArrayList<String>());
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        if (proofs == null) {
            throw new NullPointerException("proofs is marked non-null but is null");
        }
    }

    public void addDestroyed(@NonNull String eventId) {
        if (eventId == null) {
            throw new NullPointerException("eventId is marked non-null but is null");
        }
        this.destroyed.add(eventId);
    }

    public void removeDestroyed(@NonNull String eventId) {
        if (eventId == null) {
            throw new NullPointerException("eventId is marked non-null but is null");
        }
        this.destroyed.remove(eventId);
    }

    public Integer calculateAmount() {
        if (this.proofs == null || this.proofs.isEmpty()) {
            return 0;
        }
        return this.proofs.stream().mapToInt(CashuProof::getAmount).sum();
    }

    public int getDestroyedCount() {
        return this.destroyed != null ? this.destroyed.size() : 0;
    }

    public boolean containsDestroyed(@NonNull String eventId) {
        if (eventId == null) {
            throw new NullPointerException("eventId is marked non-null but is null");
        }
        return this.destroyed != null && this.destroyed.contains(eventId);
    }

    @Generated
    private static List<CashuProof> $default$proofs() {
        return new ArrayList<CashuProof>();
    }

    @Generated
    private static List<String> $default$destroyed() {
        return new ArrayList<String>();
    }

    @Generated
    public static CashuTokenBuilder builder() {
        return new CashuTokenBuilder();
    }

    @Generated
    public CashuMint getMint() {
        return this.mint;
    }

    @Generated
    public List<CashuProof> getProofs() {
        return this.proofs;
    }

    @Generated
    public List<String> getDestroyed() {
        return this.destroyed;
    }

    @Generated
    public void setMint(CashuMint mint) {
        this.mint = mint;
    }

    @Generated
    public void setProofs(List<CashuProof> proofs) {
        this.proofs = proofs;
    }

    @Generated
    public void setDestroyed(List<String> destroyed) {
        this.destroyed = destroyed;
    }

    @Generated
    public String toString() {
        return "CashuToken(mint=" + String.valueOf(this.getMint()) + ", proofs=" + String.valueOf(this.getProofs()) + ", destroyed=" + String.valueOf(this.getDestroyed()) + ")";
    }

    @Generated
    public CashuToken(CashuMint mint, List<CashuProof> proofs, List<String> destroyed) {
        this.mint = mint;
        this.proofs = proofs;
        this.destroyed = destroyed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CashuToken)) {
            return false;
        }
        CashuToken other = (CashuToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CashuMint this$mint = this.getMint();
        CashuMint other$mint = other.getMint();
        if (this$mint == null ? other$mint != null : !((Object)this$mint).equals(other$mint)) {
            return false;
        }
        List<CashuProof> this$proofs = this.getProofs();
        List<CashuProof> other$proofs = other.getProofs();
        return !(this$proofs == null ? other$proofs != null : !((Object)this$proofs).equals(other$proofs));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CashuToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CashuMint $mint = this.getMint();
        result = result * 59 + ($mint == null ? 43 : ((Object)$mint).hashCode());
        List<CashuProof> $proofs = this.getProofs();
        result = result * 59 + ($proofs == null ? 43 : ((Object)$proofs).hashCode());
        return result;
    }

    @Generated
    public static class CashuTokenBuilder {
        @Generated
        private CashuMint mint;
        @Generated
        private boolean proofs$set;
        @Generated
        private List<CashuProof> proofs$value;
        @Generated
        private boolean destroyed$set;
        @Generated
        private List<String> destroyed$value;

        @Generated
        CashuTokenBuilder() {
        }

        @Generated
        public CashuTokenBuilder mint(CashuMint mint) {
            this.mint = mint;
            return this;
        }

        @Generated
        public CashuTokenBuilder proofs(List<CashuProof> proofs) {
            this.proofs$value = proofs;
            this.proofs$set = true;
            return this;
        }

        @Generated
        public CashuTokenBuilder destroyed(List<String> destroyed) {
            this.destroyed$value = destroyed;
            this.destroyed$set = true;
            return this;
        }

        @Generated
        public CashuToken build() {
            List<CashuProof> proofs$value = this.proofs$value;
            if (!this.proofs$set) {
                proofs$value = CashuToken.$default$proofs();
            }
            List<String> destroyed$value = this.destroyed$value;
            if (!this.destroyed$set) {
                destroyed$value = CashuToken.$default$destroyed();
            }
            return new CashuToken(this.mint, proofs$value, destroyed$value);
        }

        @Generated
        public String toString() {
            return "CashuToken.CashuTokenBuilder(mint=" + String.valueOf(this.mint) + ", proofs$value=" + String.valueOf(this.proofs$value) + ", destroyed$value=" + String.valueOf(this.destroyed$value) + ")";
        }
    }
}

