/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.base.BaseKey;
import nostr.base.PublicKey;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;

public class AuthorFilter<T extends PublicKey>
extends AbstractFilterable<T> {
    public static final String FILTER_KEY = "authors";
    public static Function<JsonNode, Filterable> fxn = node -> new AuthorFilter<PublicKey>(new PublicKey(node.asText()));

    public AuthorFilter(T publicKey) {
        super(publicKey, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> genericEvent.getPubKey().toHexString().equals(this.getFilterableValue());
    }

    @Override
    public String getFilterableValue() {
        return ((BaseKey)this.getAuthor()).toHexString();
    }

    private T getAuthor() {
        return (T)((PublicKey)super.getFilterable());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorFilter)) {
            return false;
        }
        AuthorFilter other = (AuthorFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthorFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

