/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.UrlTag;

public class UrlTagFilter<T extends UrlTag>
extends AbstractFilterable<T> {
    public static final String FILTER_KEY = "#u";
    public static Function<JsonNode, Filterable> fxn = node -> new UrlTagFilter<UrlTag>(new UrlTag(node.asText()));

    public UrlTagFilter(T urlTag) {
        super(urlTag, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> Filterable.getTypeSpecificTags(UrlTag.class, genericEvent).stream().anyMatch(urlTag -> urlTag.getUrl().equals(this.getFilterableValue()));
    }

    @Override
    public Object getFilterableValue() {
        return ((UrlTag)this.getUrlTag()).getUrl();
    }

    private T getUrlTag() {
        return (T)((UrlTag)super.getFilterable());
    }
}

