/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.CalendarRsvpContent;
import nostr.event.filter.Filterable;
import nostr.event.impl.AbstractBaseCalendarEvent;
import nostr.event.json.deserializer.CalendarRsvpEventDeserializer;
import nostr.event.tag.AddressTag;
import nostr.event.tag.EventTag;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;
import nostr.event.tag.PubKeyTag;

@Event(name="CalendarRsvpEvent", nip=52)
@JsonDeserialize(using=CalendarRsvpEventDeserializer.class)
public class CalendarRsvpEvent
extends AbstractBaseCalendarEvent<CalendarRsvpContent> {
    public CalendarRsvpEvent(@NonNull PublicKey sender, @NonNull List<BaseTag> baseTags, @NonNull String content) {
        super(sender, Kind.CALENDAR_RSVP_EVENT, baseTags, content);
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (baseTags == null) {
            throw new NullPointerException("baseTags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public Status getStatus() {
        return Status.valueOf(this.getCalendarContent().getStatus().toUpperCase());
    }

    public Optional<FB> getFB() {
        return this.getCalendarContent().getFbTag().map(fbTag -> fbTag.getAttributes().get(0).value().toString().toUpperCase()).map(FB::valueOf);
    }

    public Optional<String> getEventId() {
        return this.getCalendarContent().getEventTag().map(EventTag::getIdEvent);
    }

    @Override
    public String getId() {
        return this.getCalendarContent().getIdentifierTag().getUuid();
    }

    public Optional<PublicKey> getAuthor() {
        return this.getCalendarContent().getAuthorPubKeyTag().map(PubKeyTag::getPublicKey);
    }

    @Override
    protected CalendarRsvpContent getCalendarContent() {
        CalendarRsvpContent calendarRsvpContent = CalendarRsvpContent.builder(Filterable.requireTagOfTypeWithCode(IdentifierTag.class, "d", this), Filterable.requireTagOfTypeWithCode(AddressTag.class, "a", this), Filterable.requireTagOfTypeWithCode(GenericTag.class, "status", this).getAttributes().get(0).value().toString()).build();
        Filterable.firstTagOfType(EventTag.class, this).ifPresent(calendarRsvpContent::setEventTag);
        Optional.ofNullable(this.getTag("fb")).ifPresent(baseTag -> calendarRsvpContent.setFbTag((GenericTag)baseTag));
        Filterable.firstTagOfType(PubKeyTag.class, this).ifPresent(calendarRsvpContent::setAuthorPubKeyTag);
        return calendarRsvpContent;
    }

    @Override
    public void validateKind() {
        if (this.getKind().intValue() != Kind.CALENDAR_RSVP_EVENT.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CALENDAR_RSVP_EVENT.getValue()));
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarRsvpEvent)) {
            return false;
        }
        CalendarRsvpEvent other = (CalendarRsvpEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalendarRsvpEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public CalendarRsvpEvent() {
    }

    public static enum Status {
        ACCEPTED("accepted"),
        TENTATIVE("tentative"),
        DECLINED("declined");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        @JsonValue
        public String getStatus() {
            return this.status;
        }
    }

    public static enum FB {
        FREE("free"),
        BUSY("busy");

        private final String value;

        private FB(String fb) {
            this.value = fb;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

