/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.ZapRequest;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PubKeyTag;
import nostr.event.tag.RelaysTag;

@Event(name="ZapRequestEvent", nip=57)
public class ZapRequestEvent
extends GenericEvent {
    public ZapRequestEvent(@NonNull PublicKey recipientPubKey, @NonNull List<BaseTag> tags, @NonNull String content) {
        super(recipientPubKey, Kind.ZAP_REQUEST, tags, content);
        if (recipientPubKey == null) {
            throw new NullPointerException("recipientPubKey is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public ZapRequest getZapRequest() {
        RelaysTag relaysTag = Filterable.requireTagOfTypeWithCode(RelaysTag.class, "relays", this);
        String amount = Filterable.requireTagOfTypeWithCode(GenericTag.class, "amount", this).getAttributes().get(0).value().toString();
        String lnurl = Filterable.requireTagOfTypeWithCode(GenericTag.class, "lnurl", this).getAttributes().get(0).value().toString();
        return new ZapRequest(relaysTag, Long.parseLong(amount), lnurl);
    }

    public PublicKey getRecipientKey() {
        PubKeyTag p = Filterable.requireTagOfTypeWithCode(PubKeyTag.class, "p", this, "Recipient public key not found in tags");
        return p.getPublicKey();
    }

    public String getEventId() {
        return Filterable.firstTagOfTypeWithCode(GenericTag.class, "e", this).map(tag -> tag.getAttributes().get(0).value().toString()).orElse(null);
    }

    public List<Relay> getRelays() {
        ZapRequest zapRequest = this.getZapRequest();
        return zapRequest.getRelaysTag() != null ? zapRequest.getRelaysTag().getRelays() : null;
    }

    public String getLnUrl() {
        ZapRequest zapRequest = this.getZapRequest();
        return zapRequest.getLnUrl();
    }

    public Long getAmount() {
        ZapRequest zapRequest = this.getZapRequest();
        return zapRequest.getAmount();
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        boolean hasRecipientTag = Filterable.firstTagOfTypeWithCode(PubKeyTag.class, "p", this).isPresent();
        if (!hasRecipientTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include a `p` tag for the recipient's public key.");
        }
        boolean hasAmountTag = Filterable.firstTagOfTypeWithCode(GenericTag.class, "amount", this).isPresent();
        if (!hasAmountTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include an `amount` tag specifying the amount in millisatoshis.");
        }
        boolean hasLnUrlTag = Filterable.firstTagOfTypeWithCode(GenericTag.class, "lnurl", this).isPresent();
        if (!hasLnUrlTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include an `lnurl` tag containing the Lightning Network URL.");
        }
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.ZAP_REQUEST.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.ZAP_REQUEST.getValue()));
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZapRequestEvent)) {
            return false;
        }
        ZapRequestEvent other = (ZapRequestEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZapRequestEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public ZapRequestEvent() {
    }
}

