/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import nostr.event.entities.CashuProof;
import nostr.event.entities.CashuToken;

public class CashuTokenSerializer
extends JsonSerializer<CashuToken> {
    @Override
    public void serialize(CashuToken value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("mint", value.getMint().getUrl());
        jsonGenerator.writeArrayFieldStart("proofs");
        for (CashuProof proof : value.getProofs()) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("id", proof.getId());
            jsonGenerator.writeNumberField("amount", proof.getAmount());
            jsonGenerator.writeStringField("secret", proof.getSecret());
            jsonGenerator.writeStringField("C", proof.getC());
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        if (!value.getDestroyed().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("del");
            for (String destroyed : value.getDestroyed()) {
                jsonGenerator.writeString(destroyed);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }
}

