/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import lombok.NonNull;
import nostr.base.Relay;
import nostr.event.tag.RelaysTag;

public class RelaysTagSerializer
extends JsonSerializer<RelaysTag> {
    @Override
    public void serialize(@NonNull RelaysTag relaysTag, @NonNull JsonGenerator jsonGenerator, @NonNull SerializerProvider serializerProvider) throws IOException {
        if (relaysTag == null) {
            throw new NullPointerException("relaysTag is marked non-null but is null");
        }
        if (jsonGenerator == null) {
            throw new NullPointerException("jsonGenerator is marked non-null but is null");
        }
        if (serializerProvider == null) {
            throw new NullPointerException("serializerProvider is marked non-null but is null");
        }
        jsonGenerator.writeStartArray();
        jsonGenerator.writeString("relays");
        for (Relay relay : relaysTag.getRelays()) {
            jsonGenerator.writeString(relay.getUri());
        }
        jsonGenerator.writeEndArray();
    }

    private static void writeString(JsonGenerator jsonGenerator, String json) throws IOException {
        jsonGenerator.writeString(json);
    }
}

