/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.time.temporal.ValueRange;
import java.util.List;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Command;
import nostr.base.IDecoder;
import nostr.event.BaseMessage;
import nostr.event.filter.Filters;
import nostr.event.json.EventJsonMapper;
import nostr.event.json.codec.EventEncodingException;
import nostr.event.json.codec.FiltersDecoder;
import nostr.event.json.codec.FiltersEncoder;

public class ReqMessage
extends BaseMessage {
    public static final int FILTERS_START_INDEX = 2;
    @JsonProperty
    private final String subscriptionId;
    @JsonProperty
    private final List<Filters> filtersList;

    public ReqMessage(@NonNull String subscriptionId, Filters ... filtersList) {
        this(subscriptionId, List.of(filtersList));
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (filtersList == null) {
            throw new NullPointerException("filtersList is marked non-null but is null");
        }
    }

    public ReqMessage(@NonNull String subscriptionId, @NonNull List<Filters> filtersList) {
        super(Command.REQ.name());
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (filtersList == null) {
            throw new NullPointerException("filtersList is marked non-null but is null");
        }
        ReqMessage.validateSubscriptionId(subscriptionId);
        this.subscriptionId = subscriptionId;
        this.filtersList = filtersList;
    }

    @Override
    public String encode() throws EventEncodingException {
        ArrayNode encoderArrayNode = JsonNodeFactory.instance.arrayNode();
        encoderArrayNode.add(this.getCommand()).add(this.getSubscriptionId());
        this.filtersList.stream().map(FiltersEncoder::new).map(FiltersEncoder::encode).map(ReqMessage::createJsonNode).forEach(encoderArrayNode::add);
        try {
            return EventJsonMapper.getMapper().writeValueAsString(encoderArrayNode);
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Failed to encode req message", e);
        }
    }

    public static <T extends BaseMessage> T decode(@NonNull Object subscriptionId, @NonNull String jsonString) throws EventEncodingException {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        ReqMessage.validateSubscriptionId(subscriptionId.toString());
        ReqMessage result = new ReqMessage(subscriptionId.toString(), ReqMessage.getJsonFiltersList(jsonString).stream().map(filtersList -> new FiltersDecoder().decode((String)filtersList)).toList());
        return (T)result;
    }

    private static JsonNode createJsonNode(String jsonNode) throws EventEncodingException {
        try {
            return EventJsonMapper.getMapper().readTree(jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException(String.format("Malformed encoding ReqMessage json: [%s]", jsonNode), e);
        }
    }

    private static void validateSubscriptionId(String subscriptionId) {
        if (!ValueRange.of(1L, 64L).isValidIntValue(subscriptionId.length())) {
            throw new IllegalArgumentException(String.format("SubscriptionId length must be between 1 and 64 characters but was [%d]", subscriptionId.length()));
        }
    }

    private static List<String> getJsonFiltersList(String jsonString) throws EventEncodingException {
        try {
            JsonNode root = IDecoder.I_DECODER_MAPPER_BLACKBIRD.readTree(jsonString);
            return IntStream.range(2, root.size()).mapToObj(idx -> root.get(idx).toString()).toList();
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Invalid ReqMessage filters json", e);
        }
    }

    @Generated
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public List<Filters> getFiltersList() {
        return this.filtersList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReqMessage)) {
            return false;
        }
        ReqMessage other = (ReqMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$subscriptionId = this.getSubscriptionId();
        String other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !this$subscriptionId.equals(other$subscriptionId)) {
            return false;
        }
        List<Filters> this$filtersList = this.getFiltersList();
        List<Filters> other$filtersList = other.getFiltersList();
        return !(this$filtersList == null ? other$filtersList != null : !((Object)this$filtersList).equals(other$filtersList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReqMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : $subscriptionId.hashCode());
        List<Filters> $filtersList = this.getFiltersList();
        result = result * 59 + ($filtersList == null ? 43 : ((Object)$filtersList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReqMessage(super=" + super.toString() + ", subscriptionId=" + this.getSubscriptionId() + ", filtersList=" + String.valueOf(this.getFiltersList()) + ")";
    }
}

