/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.validator;

import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.event.BaseTag;
import nostr.util.validator.HexStringValidator;

public final class EventValidator {
    private EventValidator() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void validate(String id, PublicKey pubKey, Signature signature, Long createdAt, Integer kind, List<BaseTag> tags, String content) {
        EventValidator.validateId(id);
        EventValidator.validatePubKey(pubKey);
        EventValidator.validateSignature(signature);
        EventValidator.validateCreatedAt(createdAt);
        EventValidator.validateKind(kind);
        EventValidator.validateTags(tags);
        EventValidator.validateContent(content);
    }

    public static void validateId(@NonNull String id) {
        Objects.requireNonNull(id, "Missing required `id` field.");
        HexStringValidator.validateHex(id, 64);
    }

    public static void validatePubKey(@NonNull PublicKey pubKey) {
        Objects.requireNonNull(pubKey, "Missing required `pubkey` field.");
        HexStringValidator.validateHex(pubKey.toString(), 64);
    }

    public static void validateSignature(@NonNull Signature signature) {
        Objects.requireNonNull(signature, "Missing required `sig` field.");
        HexStringValidator.validateHex(signature.toString(), 128);
    }

    public static void validateCreatedAt(Long createdAt) {
        if (createdAt == null || createdAt < 0L) {
            throw new AssertionError((Object)"Invalid `created_at`: Must be a non-negative integer.");
        }
    }

    public static void validateKind(Integer kind) {
        if (kind == null || kind < 0) {
            throw new AssertionError((Object)"Invalid `kind`: Must be a non-negative integer.");
        }
    }

    public static void validateTags(List<BaseTag> tags) {
        if (tags == null) {
            throw new AssertionError((Object)"Invalid `tags`: Must be a non-null array.");
        }
    }

    public static void validateContent(String content) {
        if (content == null) {
            throw new AssertionError((Object)"Invalid `content`: Must be a string.");
        }
    }
}

