/*
 * Decompiled with CFR 0.152.
 */
package nostr.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import nostr.util.validator.HexStringValidator;

public class NostrUtil {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private static final SecureRandom RANDOM = new SecureRandom();

    public static String bytesToHex(byte[] b) {
        char[] hexChars = new char[b.length * 2];
        for (int j = 0; j < b.length; ++j) {
            int v = b[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars).toLowerCase();
    }

    public static byte[] hexToBytes(String s) {
        HexStringValidator.validateHex(s, 64);
        return NostrUtil.hexToBytesConvert(s);
    }

    public static byte[] hex128ToBytes(String s) {
        HexStringValidator.validateHex(s, 128);
        return NostrUtil.hexToBytesConvert(s);
    }

    public static byte[] nip04PubKeyHexToBytes(String s) {
        HexStringValidator.validateHex(s, 66);
        return NostrUtil.hexToBytesConvert(s);
    }

    private static byte[] hexToBytesConvert(String s) {
        int len = s.length();
        byte[] buf = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            buf[i2 / 2] = (byte)((Character.digit(s.charAt(i2), 16) << 4) + Character.digit(s.charAt(i2 + 1), 16));
        }
        return buf;
    }

    public static byte[] bytesFromInt(int n) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(n).array();
    }

    public static byte[] bytesFromBigInteger(BigInteger n) {
        byte[] b = n.toByteArray();
        if (b.length == 32) {
            return b;
        }
        if (b.length > 32) {
            return Arrays.copyOfRange(b, b.length - 32, b.length);
        }
        byte[] buf = new byte[32];
        System.arraycopy(b, 0, buf, buf.length - b.length, b.length);
        return buf;
    }

    public static BigInteger bigIntFromBytes(byte[] b) {
        return new BigInteger(1, b);
    }

    public static byte[] sha256(byte[] b) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return digest.digest(b);
    }

    public static byte[] xor(byte[] b0, byte[] b1) {
        if (b0.length != b1.length) {
            return null;
        }
        byte[] ret = new byte[b0.length];
        int i2 = 0;
        for (byte b : b0) {
            ret[i2] = (byte)(b ^ b1[i2]);
            ++i2;
        }
        return ret;
    }

    public static byte[] createRandomByteArray(int len) {
        byte[] b = new byte[len];
        RANDOM.nextBytes(b);
        return b;
    }

    public static String escapeJsonString(String jsonString) {
        return jsonString.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static String unEscapeJsonString(String jsonString) {
        return jsonString.replace("\\\\", "\\").replace("\\\"", "\"").replace("\\b", "\b").replace("\\f", "\f").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t");
    }
}

