/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Request;
import org.apache.coyote.ActionCode;
import org.apache.coyote.UpgradeProtocol;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLHostConfig;

public class SSLAuthenticator
extends AuthenticatorBase {
    private final Log log = LogFactory.getLog(SSLAuthenticator.class);

    @Override
    protected boolean doAuthenticate(Request request, HttpServletResponse response) throws IOException {
        X509Certificate[] certs;
        if (this.checkForCachedAuthentication(request, response, false)) {
            return true;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace(" Looking up certificates");
        }
        if ((certs = this.getRequestCertificates(request)) == null || certs.length < 1) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug(sm.getString("sslAuthenticatorValve.noCertificates"));
            }
            response.sendError(401, sm.getString("authenticator.certificates"));
            return false;
        }
        Principal principal2 = this.context.getRealm().authenticate(certs);
        if (principal2 == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug(sm.getString("sslAuthenticatorValve.authFailed"));
            }
            response.sendError(401, sm.getString("authenticator.unauthorized"));
            return false;
        }
        this.register(request, response, principal2, "CLIENT_CERT", null, null);
        return true;
    }

    @Override
    protected String getAuthMethod() {
        return "CLIENT_CERT";
    }

    @Override
    protected boolean isPreemptiveAuthPossible(Request request) {
        X509Certificate[] certs = this.getRequestCertificates(request);
        return certs != null && certs.length > 0;
    }

    protected X509Certificate[] getRequestCertificates(Request request) throws IllegalStateException {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
        if (certs == null || certs.length < 1) {
            try {
                request.getCoyoteRequest().action(ActionCode.REQ_SSL_CERTIFICATE, null);
                certs = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return certs;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        Connector[] connectors;
        super.startInternal();
        Container container = this.getContainer();
        if (!(container instanceof Context)) {
            return;
        }
        Context context = (Context)container;
        if (!((container = context.getParent()) instanceof Host)) {
            return;
        }
        Host host = (Host)container;
        if (!((container = host.getParent()) instanceof Engine)) {
            return;
        }
        Engine engine = (Engine)container;
        for (Connector connector : connectors = engine.getService().findConnectors()) {
            boolean allHostsRequireCertificate = true;
            for (SSLHostConfig sslHostConfig : connector.findSslHostConfigs()) {
                if (sslHostConfig.getCertificateVerification() == SSLHostConfig.CertificateVerification.REQUIRED) continue;
                allHostsRequireCertificate = false;
                break;
            }
            if (allHostsRequireCertificate) continue;
            UpgradeProtocol[] upgradeProtocols = connector.findUpgradeProtocols();
            for (UpgradeProtocol upgradeProtocol : upgradeProtocols) {
                if (!"h2".equals(upgradeProtocol.getAlpnName())) continue;
                this.log.warn(sm.getString("sslAuthenticatorValve.http2", context.getName(), host.getName(), connector));
                break;
            }
            for (SSLHostConfig sslHostConfig : connector.findSslHostConfigs()) {
                if (sslHostConfig.isTls13RenegotiationAvailable()) continue;
                String[] enabledProtocols = sslHostConfig.getEnabledProtocols();
                if (enabledProtocols == null) {
                    enabledProtocols = sslHostConfig.getProtocols().toArray(new String[0]);
                }
                for (String enabledProtocol : enabledProtocols) {
                    if (!"TLSv1.3".equals(enabledProtocol)) continue;
                    this.log.warn(sm.getString("sslAuthenticatorValve.tls13", context.getName(), host.getName(), connector));
                }
            }
        }
    }
}

