/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.lang;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.LambdaExpression;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.el.lang.ELArithmetic;
import org.apache.el.util.ExceptionUtils;
import org.apache.el.util.MessageFactory;

public class ELSupport {
    private static final Long ZERO = 0L;
    protected static final boolean COERCE_TO_ZERO;

    public static int compare(ELContext ctx, Object obj0, Object obj1) throws ELException {
        if (obj0 == obj1 || ELSupport.equals(ctx, obj0, obj1)) {
            return 0;
        }
        if (ELSupport.isBigDecimalOp(obj0, obj1)) {
            BigDecimal bd0 = (BigDecimal)ELSupport.coerceToNumber(ctx, obj0, BigDecimal.class);
            BigDecimal bd1 = (BigDecimal)ELSupport.coerceToNumber(ctx, obj1, BigDecimal.class);
            return bd0.compareTo(bd1);
        }
        if (ELSupport.isDoubleOp(obj0, obj1)) {
            Double d0 = (Double)ELSupport.coerceToNumber(ctx, obj0, Double.class);
            Double d1 = (Double)ELSupport.coerceToNumber(ctx, obj1, Double.class);
            return d0.compareTo(d1);
        }
        if (ELSupport.isBigIntegerOp(obj0, obj1)) {
            BigInteger bi0 = (BigInteger)ELSupport.coerceToNumber(ctx, obj0, BigInteger.class);
            BigInteger bi1 = (BigInteger)ELSupport.coerceToNumber(ctx, obj1, BigInteger.class);
            return bi0.compareTo(bi1);
        }
        if (ELSupport.isLongOp(obj0, obj1)) {
            Long l0 = (Long)ELSupport.coerceToNumber(ctx, obj0, Long.class);
            Long l1 = (Long)ELSupport.coerceToNumber(ctx, obj1, Long.class);
            return l0.compareTo(l1);
        }
        if (obj0 instanceof String || obj1 instanceof String) {
            return ELSupport.coerceToString(ctx, obj0).compareTo(ELSupport.coerceToString(ctx, obj1));
        }
        if (obj0 instanceof Comparable) {
            Comparable comparable = (Comparable)obj0;
            return obj1 != null ? comparable.compareTo(obj1) : 1;
        }
        if (obj1 instanceof Comparable) {
            Comparable comparable = (Comparable)obj1;
            return obj0 != null ? -comparable.compareTo(obj0) : -1;
        }
        throw new ELException(MessageFactory.get("error.compare", obj0, obj1));
    }

    public static boolean equals(ELContext ctx, Object obj0, Object obj1) throws ELException {
        if (obj0 == obj1) {
            return true;
        }
        if (obj0 == null || obj1 == null) {
            return false;
        }
        if (ELSupport.isBigDecimalOp(obj0, obj1)) {
            BigDecimal bd0 = (BigDecimal)ELSupport.coerceToNumber(ctx, obj0, BigDecimal.class);
            BigDecimal bd1 = (BigDecimal)ELSupport.coerceToNumber(ctx, obj1, BigDecimal.class);
            return bd0.equals(bd1);
        }
        if (ELSupport.isDoubleOp(obj0, obj1)) {
            Double d0 = (Double)ELSupport.coerceToNumber(ctx, obj0, Double.class);
            Double d1 = (Double)ELSupport.coerceToNumber(ctx, obj1, Double.class);
            return d0.equals(d1);
        }
        if (ELSupport.isBigIntegerOp(obj0, obj1)) {
            BigInteger bi0 = (BigInteger)ELSupport.coerceToNumber(ctx, obj0, BigInteger.class);
            BigInteger bi1 = (BigInteger)ELSupport.coerceToNumber(ctx, obj1, BigInteger.class);
            return bi0.equals(bi1);
        }
        if (ELSupport.isLongOp(obj0, obj1)) {
            Long l0 = (Long)ELSupport.coerceToNumber(ctx, obj0, Long.class);
            Long l1 = (Long)ELSupport.coerceToNumber(ctx, obj1, Long.class);
            return l0.equals(l1);
        }
        if (obj0 instanceof Boolean || obj1 instanceof Boolean) {
            return ELSupport.coerceToBoolean(ctx, obj0, false).equals(ELSupport.coerceToBoolean(ctx, obj1, false));
        }
        if (obj0.getClass().isEnum()) {
            return obj0.equals(ELSupport.coerceToEnum(ctx, obj1, obj0.getClass()));
        }
        if (obj1.getClass().isEnum()) {
            return obj1.equals(ELSupport.coerceToEnum(ctx, obj0, obj1.getClass()));
        }
        if (obj0 instanceof String || obj1 instanceof String) {
            int lexCompare = ELSupport.coerceToString(ctx, obj0).compareTo(ELSupport.coerceToString(ctx, obj1));
            return lexCompare == 0;
        }
        return obj0.equals(obj1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enum<?> coerceToEnum(ELContext ctx, Object obj, Class type) {
        Object result;
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                Object result2 = ctx.getELResolver().convertToType(ctx, obj, type);
                if (ctx.isPropertyResolved()) {
                    Enum enum_ = (Enum)result2;
                    return enum_;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (obj == null || "".equals(obj)) {
            return null;
        }
        if (type.isAssignableFrom(obj.getClass())) {
            return (Enum)obj;
        }
        if (!(obj instanceof String)) {
            throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
        }
        try {
            result = Enum.valueOf(type, (String)obj);
        }
        catch (IllegalArgumentException iae) {
            throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean coerceToBoolean(ELContext ctx, Object obj, boolean primitive) throws ELException {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                Boolean result = ctx.getELResolver().convertToType(ctx, obj, Boolean.class);
                if (ctx.isPropertyResolved()) {
                    Boolean bl = result;
                    return bl;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (!COERCE_TO_ZERO && !primitive && obj == null) {
            return null;
        }
        if (obj == null || "".equals(obj)) {
            return Boolean.FALSE;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), Boolean.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Character coerceToCharacter(ELContext ctx, Object obj) throws ELException {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                Character result = ctx.getELResolver().convertToType(ctx, obj, Character.class);
                if (ctx.isPropertyResolved()) {
                    Character c = result;
                    return c;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (obj == null || "".equals(obj)) {
            return Character.valueOf('\u0000');
        }
        if (obj instanceof String) {
            return Character.valueOf(((String)obj).charAt(0));
        }
        if (ELArithmetic.isNumber(obj)) {
            return Character.valueOf((char)((Number)obj).shortValue());
        }
        Class<?> objType = obj.getClass();
        if (obj instanceof Character) {
            return (Character)obj;
        }
        throw new ELException(MessageFactory.get("error.convert", obj, objType, Character.class));
    }

    protected static Number coerceToNumber(Number number, Class<?> type) throws ELException {
        if (Long.TYPE == type || Long.class.equals(type)) {
            return number.longValue();
        }
        if (Double.TYPE == type || Double.class.equals(type)) {
            return number.doubleValue();
        }
        if (Integer.TYPE == type || Integer.class.equals(type)) {
            return number.intValue();
        }
        if (BigInteger.class.equals(type)) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            if (number instanceof BigInteger) {
                return number;
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (BigDecimal.class.equals(type)) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }
        if (Byte.TYPE == type || Byte.class.equals(type)) {
            return number.byteValue();
        }
        if (Short.TYPE == type || Short.class.equals(type)) {
            return number.shortValue();
        }
        if (Float.TYPE == type || Float.class.equals(type)) {
            return Float.valueOf(number.floatValue());
        }
        if (Number.class.equals(type)) {
            return number;
        }
        throw new ELException(MessageFactory.get("error.convert", number, number.getClass(), type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Number coerceToNumber(ELContext ctx, Object obj, Class<?> type) throws ELException {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                Object result = ctx.getELResolver().convertToType(ctx, obj, type);
                if (ctx.isPropertyResolved()) {
                    Number number = (Number)result;
                    return number;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (!COERCE_TO_ZERO && obj == null && !type.isPrimitive()) {
            return null;
        }
        if (obj == null || "".equals(obj)) {
            return ELSupport.coerceToNumber(ZERO, type);
        }
        if (obj instanceof String) {
            return ELSupport.coerceToNumber((String)obj, type);
        }
        if (ELArithmetic.isNumber(obj)) {
            return ELSupport.coerceToNumber((Number)obj, type);
        }
        if (obj instanceof Character) {
            return ELSupport.coerceToNumber((short)((Character)obj).charValue(), type);
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
    }

    protected static Number coerceToNumber(String val, Class<?> type) throws ELException {
        if (Long.TYPE == type || Long.class.equals(type)) {
            try {
                return Long.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type));
            }
        }
        if (Integer.TYPE == type || Integer.class.equals(type)) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type));
            }
        }
        if (Double.TYPE == type || Double.class.equals(type)) {
            try {
                return Double.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type));
            }
        }
        if (BigInteger.class.equals(type)) {
            try {
                return new BigInteger(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type));
            }
        }
        if (BigDecimal.class.equals(type)) {
            try {
                return new BigDecimal(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type));
            }
        }
        if (Byte.TYPE == type || Byte.class.equals(type)) {
            try {
                return Byte.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type));
            }
        }
        if (Short.TYPE == type || Short.class.equals(type)) {
            try {
                return Short.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type));
            }
        }
        if (Float.TYPE == type || Float.class.equals(type)) {
            try {
                return Float.valueOf(val);
            }
            catch (NumberFormatException nfe) {
                throw new ELException(MessageFactory.get("error.convert", val, String.class, type));
            }
        }
        throw new ELException(MessageFactory.get("error.convert", val, String.class, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String coerceToString(ELContext ctx, Object obj) {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                String result = ctx.getELResolver().convertToType(ctx, obj, String.class);
                if (ctx.isPropertyResolved()) {
                    String string = result;
                    return string;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        try {
            return obj.toString();
        }
        catch (ELException e) {
            throw e;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            throw new ELException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T coerceToType(ELContext ctx, Object obj, Class<T> type) throws ELException {
        if (ctx != null) {
            boolean originalIsPropertyResolved = ctx.isPropertyResolved();
            try {
                T result = ctx.getELResolver().convertToType(ctx, obj, type);
                if (ctx.isPropertyResolved()) {
                    T t = result;
                    return t;
                }
            }
            finally {
                ctx.setPropertyResolved(originalIsPropertyResolved);
            }
        }
        if (type == null || Object.class.equals(type) || obj != null && type.isAssignableFrom(obj.getClass())) {
            Object result = obj;
            return (T)result;
        }
        if (!(COERCE_TO_ZERO || obj != null || type.isPrimitive() || String.class.isAssignableFrom(type))) {
            return null;
        }
        if (String.class.equals(type)) {
            String result = ELSupport.coerceToString(ctx, obj);
            return (T)result;
        }
        if (ELArithmetic.isNumberType(type)) {
            Number result = ELSupport.coerceToNumber(ctx, obj, type);
            return (T)result;
        }
        if (Character.class.equals(type) || Character.TYPE == type) {
            Character result = ELSupport.coerceToCharacter(ctx, obj);
            return (T)result;
        }
        if (Boolean.class.equals(type) || Boolean.TYPE == type) {
            Boolean result = ELSupport.coerceToBoolean(ctx, obj, Boolean.TYPE == type);
            return (T)result;
        }
        if (type.isEnum()) {
            Enum<?> result = ELSupport.coerceToEnum(ctx, obj, type);
            return (T)result;
        }
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            PropertyEditor editor = PropertyEditorManager.findEditor(type);
            if (editor == null) {
                if (str.isEmpty()) {
                    return null;
                }
                throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
            }
            try {
                editor.setAsText(str);
                Object result = editor.getValue();
                return (T)result;
            }
            catch (RuntimeException e) {
                if (str.isEmpty()) {
                    return null;
                }
                throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type), e);
            }
        }
        if (obj instanceof Set && type == Map.class && ((Set)obj).isEmpty()) {
            Map result = Collections.EMPTY_MAP;
            return (T)result;
        }
        if (type.isArray() && obj.getClass().isArray()) {
            Object result = ELSupport.coerceToArray(ctx, obj, type);
            return (T)result;
        }
        if (obj instanceof LambdaExpression && ELSupport.isFunctionalInterface(type)) {
            return ELSupport.coerceToFunctionalInterface(ctx, (LambdaExpression)obj, type);
        }
        throw new ELException(MessageFactory.get("error.convert", obj, obj.getClass(), type));
    }

    private static Object coerceToArray(ELContext ctx, Object obj, Class<?> type) {
        int size = Array.getLength(obj);
        Class<?> componentType = type.getComponentType();
        Object result = Array.newInstance(componentType, size);
        for (int i2 = 0; i2 < size; ++i2) {
            Array.set(result, i2, ELSupport.coerceToType(ctx, Array.get(obj, i2), componentType));
        }
        return result;
    }

    private static <T> T coerceToFunctionalInterface(ELContext ctx, LambdaExpression lambdaExpression, Class<T> type) {
        Supplier<Object> proxy = () -> {
            Object result = Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (obj, method, args2) -> {
                if (!Modifier.isAbstract(method.getModifiers())) {
                    throw new ELException(MessageFactory.get("elSupport.coerce.nonAbstract", type, method));
                }
                if (ctx == null) {
                    return lambdaExpression.invoke(args2);
                }
                return lambdaExpression.invoke(ctx, args2);
            });
            return result;
        };
        if (System.getSecurityManager() != null) {
            return (T)AccessController.doPrivileged(proxy::get);
        }
        return (T)proxy.get();
    }

    public static boolean isBigDecimalOp(Object obj0, Object obj1) {
        return obj0 instanceof BigDecimal || obj1 instanceof BigDecimal;
    }

    public static boolean isBigIntegerOp(Object obj0, Object obj1) {
        return obj0 instanceof BigInteger || obj1 instanceof BigInteger;
    }

    public static boolean isDoubleOp(Object obj0, Object obj1) {
        return obj0 instanceof Double || obj1 instanceof Double || obj0 instanceof Float || obj1 instanceof Float;
    }

    public static boolean isLongOp(Object obj0, Object obj1) {
        return obj0 instanceof Long || obj1 instanceof Long || obj0 instanceof Integer || obj1 instanceof Integer || obj0 instanceof Character || obj1 instanceof Character || obj0 instanceof Short || obj1 instanceof Short || obj0 instanceof Byte || obj1 instanceof Byte;
    }

    public static boolean isStringFloat(String str) {
        int len = str.length();
        if (len > 1) {
            for (int i2 = 0; i2 < len; ++i2) {
                switch (str.charAt(i2)) {
                    case 'E': {
                        return true;
                    }
                    case 'e': {
                        return true;
                    }
                    case '.': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static boolean isFunctionalInterface(Class<?> type) {
        Method[] methods;
        if (!type.isInterface()) {
            return false;
        }
        boolean foundAbstractMethod = false;
        for (Method method : methods = type.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers()) || ELSupport.overridesObjectMethod(method)) continue;
            if (foundAbstractMethod) {
                return false;
            }
            foundAbstractMethod = true;
        }
        return foundAbstractMethod;
    }

    private static boolean overridesObjectMethod(Method method) {
        if ("equals".equals(method.getName())) {
            if (method.getReturnType().equals(Boolean.TYPE) && method.getParameterCount() == 1) {
                return method.getParameterTypes()[0].equals(Object.class);
            }
        } else if ("hashCode".equals(method.getName()) ? method.getReturnType().equals(Integer.TYPE) : "toString".equals(method.getName()) && method.getReturnType().equals(String.class)) {
            return method.getParameterCount() == 0;
        }
        return false;
    }

    private ELSupport() {
    }

    static {
        String coerceToZeroStr = System.getSecurityManager() != null ? AccessController.doPrivileged(() -> System.getProperty("org.apache.el.parser.COERCE_TO_ZERO", "false")) : System.getProperty("org.apache.el.parser.COERCE_TO_ZERO", "false");
        COERCE_TO_ZERO = Boolean.parseBoolean(coerceToZeroStr);
    }
}

