/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.json;

import org.apache.tomcat.util.json.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected static String EOL = System.getProperty("line.separator", "\n");
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        for (int i2 = 0; i2 < expectedTokenSequences.length; ++i2) {
            if (maxSize < expectedTokenSequences[i2].length) {
                maxSize = expectedTokenSequences[i2].length;
            }
            for (int j = 0; j < expectedTokenSequences[i2].length; ++j) {
                expected.append(tokenImage[expectedTokenSequences[i2][j]]).append(' ');
            }
            if (expectedTokenSequences[i2][expectedTokenSequences[i2].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(EOL).append("    ");
        }
        Object retval = "Encountered \"";
        Token tok = currentToken.next;
        for (int i3 = 0; i3 < maxSize; ++i3) {
            if (i3 != 0) {
                retval = (String)retval + " ";
            }
            if (tok.kind == 0) {
                retval = (String)retval + tokenImage[0];
                break;
            }
            retval = (String)retval + " " + tokenImage[tok.kind];
            retval = (String)retval + " \"";
            retval = (String)retval + ParseException.add_escapes(tok.image);
            retval = (String)retval + " \"";
            tok = tok.next;
        }
        retval = (String)retval + "\" at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn;
        retval = (String)retval + "." + EOL;
        if (expectedTokenSequences.length != 0) {
            retval = expectedTokenSequences.length == 1 ? (String)retval + "Was expecting:" + EOL + "    " : (String)retval + "Was expecting one of:" + EOL + "    ";
            retval = (String)retval + expected.toString();
        }
        return retval;
    }

    static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block10: for (int i2 = 0; i2 < str.length(); ++i2) {
            switch (str.charAt(i2)) {
                case '\b': {
                    retval.append("\\b");
                    continue block10;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block10;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block10;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block10;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block10;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block10;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    char ch = str.charAt(i2);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block10;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

