/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

public class GenericSignature {

    public static class TypeArgument {
        public boolean isWildcard = false;
        public boolean isPlus = false;
        public boolean isMinus = false;
        public FieldTypeSignature signature;

        public TypeArgument() {
            this.isWildcard = true;
        }

        public TypeArgument(boolean plus2, boolean minus2, FieldTypeSignature aSig) {
            this.isPlus = plus2;
            this.isMinus = minus2;
            this.signature = aSig;
        }

        public String toString() {
            if (this.isWildcard) {
                return "*";
            }
            StringBuilder sb = new StringBuilder();
            if (this.isPlus) {
                sb.append("+");
            }
            if (this.isMinus) {
                sb.append("-");
            }
            sb.append(this.signature.toString());
            return sb.toString();
        }
    }

    public static class SimpleClassTypeSignature {
        public String identifier;
        public TypeArgument[] typeArguments;

        public SimpleClassTypeSignature(String identifier) {
            this.identifier = identifier;
            this.typeArguments = new TypeArgument[0];
        }

        public SimpleClassTypeSignature(String identifier, TypeArgument[] args2) {
            this.identifier = identifier;
            this.typeArguments = args2;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.identifier);
            if (this.typeArguments.length > 0) {
                sb.append("<");
                for (TypeArgument typeArgument : this.typeArguments) {
                    sb.append(typeArgument.toString());
                }
                sb.append(">");
            }
            return sb.toString();
        }
    }

    public static class ArrayTypeSignature
    extends FieldTypeSignature {
        public TypeSignature typeSig;

        public ArrayTypeSignature(TypeSignature aTypeSig) {
            this.typeSig = aTypeSig;
        }

        @Override
        public boolean isArrayTypeSignature() {
            return true;
        }

        public String toString() {
            return "[" + this.typeSig.toString();
        }
    }

    public static class TypeVariableSignature
    extends FieldTypeSignature {
        public String typeVariableName;

        public TypeVariableSignature(String typeVarToken) {
            this.typeVariableName = typeVarToken.substring(1);
        }

        @Override
        public boolean isTypeVariableSignature() {
            return true;
        }

        public String toString() {
            return "T" + this.typeVariableName + ";";
        }
    }

    public static class ClassTypeSignature
    extends FieldTypeSignature {
        public static final ClassTypeSignature[] NONE = new ClassTypeSignature[0];
        public String classSignature;
        public SimpleClassTypeSignature outerType;
        public SimpleClassTypeSignature[] nestedTypes;

        public ClassTypeSignature(String sig, String identifier) {
            this.classSignature = sig;
            this.outerType = new SimpleClassTypeSignature(identifier);
            this.nestedTypes = new SimpleClassTypeSignature[0];
        }

        public ClassTypeSignature(String sig, SimpleClassTypeSignature outer, SimpleClassTypeSignature[] inners) {
            this.classSignature = sig;
            this.outerType = outer;
            this.nestedTypes = inners;
        }

        @Override
        public boolean isClassTypeSignature() {
            return true;
        }

        public String toString() {
            return this.classSignature;
        }
    }

    public static abstract class FieldTypeSignature
    extends TypeSignature {
        public boolean isClassTypeSignature() {
            return false;
        }

        public boolean isTypeVariableSignature() {
            return false;
        }

        public boolean isArrayTypeSignature() {
            return false;
        }
    }

    public static class BaseTypeSignature
    extends TypeSignature {
        private final String sig;

        public BaseTypeSignature(String aPrimitiveType) {
            this.sig = aPrimitiveType;
        }

        @Override
        public boolean isBaseType() {
            return true;
        }

        public String toString() {
            return this.sig;
        }
    }

    public static abstract class TypeSignature {
        public boolean isBaseType() {
            return false;
        }
    }

    public static class FormalTypeParameter {
        public static final FormalTypeParameter[] NONE = new FormalTypeParameter[0];
        public String identifier;
        public FieldTypeSignature classBound;
        public FieldTypeSignature[] interfaceBounds;

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("T");
            ret.append(this.identifier);
            ret.append(":");
            ret.append(this.classBound.toString());
            for (FieldTypeSignature interfaceBound : this.interfaceBounds) {
                ret.append(":");
                ret.append(interfaceBound.toString());
            }
            return ret.toString();
        }
    }

    public static class MethodTypeSignature {
        public FormalTypeParameter[] formalTypeParameters = FormalTypeParameter.NONE;
        public TypeSignature[] parameters = new TypeSignature[0];
        public TypeSignature returnType;
        public FieldTypeSignature[] throwsSignatures = new FieldTypeSignature[0];

        public MethodTypeSignature(FormalTypeParameter[] aFormalParameterList, TypeSignature[] aParameterList, TypeSignature aReturnType, FieldTypeSignature[] aThrowsSignatureList) {
            this.formalTypeParameters = aFormalParameterList;
            this.parameters = aParameterList;
            this.returnType = aReturnType;
            this.throwsSignatures = aThrowsSignatureList;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.formalTypeParameters.length > 0) {
                sb.append("<");
                for (FormalTypeParameter formalTypeParameter : this.formalTypeParameters) {
                    sb.append(formalTypeParameter.toString());
                }
                sb.append(">");
            }
            sb.append("(");
            for (TypeSignature parameter : this.parameters) {
                sb.append(parameter.toString());
            }
            sb.append(")");
            sb.append(this.returnType.toString());
            for (FieldTypeSignature throwsSignature : this.throwsSignatures) {
                sb.append("^");
                sb.append(throwsSignature.toString());
            }
            return sb.toString();
        }
    }

    public static class ClassSignature {
        public FormalTypeParameter[] formalTypeParameters = FormalTypeParameter.NONE;
        public ClassTypeSignature superclassSignature;
        public ClassTypeSignature[] superInterfaceSignatures = ClassTypeSignature.NONE;

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append(this.formalTypeParameters.toString());
            ret.append(this.superclassSignature.toString());
            for (ClassTypeSignature superInterfaceSignature : this.superInterfaceSignatures) {
                ret.append(superInterfaceSignature.toString());
            }
            return ret.toString();
        }
    }
}

