/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;
import org.aspectj.util.UtilClassLoader;

public class Reflection {
    public static final Class<?>[] MAIN_PARM_TYPES = new Class[]{String[].class};

    private Reflection() {
    }

    public static Object invokestaticN(Class<?> class_, String name, Object[] args2) {
        return Reflection.invokeN(class_, name, null, args2);
    }

    public static Object invoke(Class<?> class_, Object target, String name, Object arg1, Object arg2) {
        return Reflection.invokeN(class_, name, target, new Object[]{arg1, arg2});
    }

    public static Object invoke(Class<?> class_, Object target, String name, Object arg1, Object arg2, Object arg3) {
        return Reflection.invokeN(class_, name, target, new Object[]{arg1, arg2, arg3});
    }

    public static Object invokeN(Class<?> class_, String name, Object target, Object[] args2) {
        Method meth = Reflection.getMatchingMethod(class_, name, args2);
        try {
            return meth.invoke(target, args2);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.toString());
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            t.printStackTrace();
            throw new RuntimeException(t.toString());
        }
    }

    public static Method getMatchingMethod(Class<?> class_, String name, Object[] args2) {
        Method[] meths;
        for (Method meth : meths = class_.getMethods()) {
            if (!meth.getName().equals(name) || !Reflection.isCompatible(meth, args2)) continue;
            return meth;
        }
        return null;
    }

    private static boolean isCompatible(Method meth, Object[] args2) {
        return meth.getParameterTypes().length == args2.length;
    }

    public static Object getStaticField(Class<?> class_, String name) {
        try {
            return class_.getField(name).get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unimplemented");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("unimplemented");
        }
    }

    public static void runMainInSameVM(String classpath, String className, String[] args2) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        String[] entries;
        LangUtil.throwIaxIfNull(className, "class name");
        if (LangUtil.isEmpty(classpath)) {
            Class<?> mainClass = Class.forName(className);
            Reflection.runMainInSameVM(mainClass, args2);
            return;
        }
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> libs = new ArrayList<File>();
        ArrayList<URL> urls2 = new ArrayList<URL>();
        for (String entry : entries = LangUtil.splitClasspath(classpath)) {
            File file;
            URL url = Reflection.makeURL(entry);
            if (null != url) {
                urls2.add(url);
            }
            if (FileUtil.isZipFile(file = new File(entry))) {
                libs.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            dirs.add(file);
        }
        File[] dirRa = dirs.toArray(new File[0]);
        File[] libRa = libs.toArray(new File[0]);
        URL[] urlRa = urls2.toArray(new URL[0]);
        Reflection.runMainInSameVM(urlRa, libRa, dirRa, className, args2);
    }

    public static void runMainInSameVM(URL[] urls2, File[] libs, File[] dirs, String className, String[] args2) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        LangUtil.throwIaxIfNull(className, "class name");
        LangUtil.throwIaxIfNotAssignable(libs, File.class, "jars");
        LangUtil.throwIaxIfNotAssignable(dirs, File.class, "dirs");
        Object[] libUrls = FileUtil.getFileURLs(libs);
        if (!LangUtil.isEmpty(libUrls)) {
            if (!LangUtil.isEmpty(urls2)) {
                URL[] temp = new URL[libUrls.length + urls2.length];
                System.arraycopy(urls2, 0, temp, 0, urls2.length);
                System.arraycopy(urls2, 0, temp, libUrls.length, urls2.length);
                urls2 = temp;
            } else {
                urls2 = libUrls;
            }
        }
        UtilClassLoader loader = new UtilClassLoader((URL[])urls2, dirs);
        Class<?> targetClass = null;
        try {
            targetClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            String s = "unable to load class " + className + " using class loader " + loader;
            throw new ClassNotFoundException(s);
        }
        Method main = targetClass.getMethod("main", MAIN_PARM_TYPES);
        main.invoke(null, new Object[]{args2});
    }

    public static void runMainInSameVM(Class<?> mainClass, String[] args2) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        LangUtil.throwIaxIfNull(mainClass, "main class");
        Method main = mainClass.getMethod("main", MAIN_PARM_TYPES);
        main.invoke(null, new Object[]{args2});
    }

    private static URL makeURL(String s) {
        try {
            return new URL(s);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

