/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.aot.generate.ClassNameGenerator;
import org.springframework.aot.generate.GeneratedClasses;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.util.Assert;

public class DefaultGenerationContext
implements GenerationContext {
    private final Map<String, AtomicInteger> sequenceGenerator;
    private final GeneratedClasses generatedClasses;
    private final GeneratedFiles generatedFiles;
    private final RuntimeHints runtimeHints;

    public DefaultGenerationContext(ClassNameGenerator classNameGenerator, GeneratedFiles generatedFiles) {
        this(classNameGenerator, generatedFiles, new RuntimeHints());
    }

    public DefaultGenerationContext(ClassNameGenerator classNameGenerator, GeneratedFiles generatedFiles, RuntimeHints runtimeHints) {
        this(new GeneratedClasses(classNameGenerator), generatedFiles, runtimeHints);
    }

    DefaultGenerationContext(GeneratedClasses generatedClasses, GeneratedFiles generatedFiles, RuntimeHints runtimeHints) {
        Assert.notNull((Object)generatedClasses, "'generatedClasses' must not be null");
        Assert.notNull((Object)generatedFiles, "'generatedFiles' must not be null");
        Assert.notNull((Object)runtimeHints, "'runtimeHints' must not be null");
        this.sequenceGenerator = new ConcurrentHashMap<String, AtomicInteger>();
        this.generatedClasses = generatedClasses;
        this.generatedFiles = generatedFiles;
        this.runtimeHints = runtimeHints;
    }

    protected DefaultGenerationContext(DefaultGenerationContext existing, String featureName) {
        int sequence2 = existing.sequenceGenerator.computeIfAbsent((String)featureName, key -> new AtomicInteger()).getAndIncrement();
        if (sequence2 > 0) {
            featureName = (String)featureName + sequence2;
        }
        this.sequenceGenerator = existing.sequenceGenerator;
        this.generatedClasses = existing.generatedClasses.withFeatureNamePrefix((String)featureName);
        this.generatedFiles = existing.generatedFiles;
        this.runtimeHints = existing.runtimeHints;
    }

    @Override
    public GeneratedClasses getGeneratedClasses() {
        return this.generatedClasses;
    }

    @Override
    public GeneratedFiles getGeneratedFiles() {
        return this.generatedFiles;
    }

    @Override
    public RuntimeHints getRuntimeHints() {
        return this.runtimeHints;
    }

    @Override
    public DefaultGenerationContext withName(String name) {
        return new DefaultGenerationContext(this, name);
    }

    public void writeGeneratedContent() {
        this.generatedClasses.writeTo(this.generatedFiles);
    }
}

