/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.generate;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.util.Assert;
import org.springframework.util.function.ThrowingConsumer;

public class FileSystemGeneratedFiles
implements GeneratedFiles {
    private final Function<GeneratedFiles.Kind, Path> roots;

    public FileSystemGeneratedFiles(Path root) {
        this(FileSystemGeneratedFiles.conventionRoots(root));
    }

    public FileSystemGeneratedFiles(Function<GeneratedFiles.Kind, Path> roots2) {
        Assert.notNull(roots2, "'roots' must not be null");
        Assert.isTrue(Arrays.stream(GeneratedFiles.Kind.values()).map(roots2).noneMatch(Objects::isNull), "'roots' must return a value for all file kinds");
        this.roots = roots2;
    }

    private static Function<GeneratedFiles.Kind, Path> conventionRoots(Path root) {
        Assert.notNull((Object)root, "'root' must not be null");
        return kind -> switch (kind) {
            default -> throw new IncompatibleClassChangeError();
            case GeneratedFiles.Kind.SOURCE -> root.resolve("sources");
            case GeneratedFiles.Kind.RESOURCE -> root.resolve("resources");
            case GeneratedFiles.Kind.CLASS -> root.resolve("classes");
        };
    }

    @Override
    public void handleFile(GeneratedFiles.Kind kind, String path, ThrowingConsumer<GeneratedFiles.FileHandler> handler) {
        FileSystemFileHandler fileHandler = new FileSystemFileHandler(this.toPath(kind, path));
        handler.accept(fileHandler);
    }

    private Path toPath(GeneratedFiles.Kind kind, String path) {
        Assert.notNull((Object)kind, "'kind' must not be null");
        Assert.hasLength(path, "'path' must not be empty");
        Path root = this.roots.apply(kind).toAbsolutePath().normalize();
        Path relativePath = root.resolve(path).toAbsolutePath().normalize();
        Assert.isTrue(relativePath.startsWith(root), "'path' must be relative");
        return relativePath;
    }

    static final class FileSystemFileHandler
    extends GeneratedFiles.FileHandler {
        private final Path path;

        FileSystemFileHandler(Path path) {
            super(Files.exists(path, new LinkOption[0]), () -> new FileSystemResource(path));
            this.path = path;
        }

        @Override
        protected void copy(InputStreamSource content, boolean override) {
            if (override) {
                this.copy(content, StandardCopyOption.REPLACE_EXISTING);
            } else {
                this.copy(content, new CopyOption[0]);
            }
        }

        private void copy(InputStreamSource content, CopyOption ... copyOptions) {
            try (InputStream inputStream2 = content.getInputStream();){
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                Files.copy(inputStream2, this.path, copyOptions);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public String toString() {
            return this.path.toString();
        }
    }
}

