/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.ContainerCustomizer;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.DirectRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.VirtualThreadTaskExecutor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EnableRabbit.class})
class RabbitAnnotationDrivenConfiguration {
    private final ObjectProvider<MessageConverter> messageConverter;
    private final ObjectProvider<MessageRecoverer> messageRecoverer;
    private final ObjectProvider<RabbitRetryTemplateCustomizer> retryTemplateCustomizers;
    private final RabbitProperties properties;

    RabbitAnnotationDrivenConfiguration(ObjectProvider<MessageConverter> messageConverter, ObjectProvider<MessageRecoverer> messageRecoverer, ObjectProvider<RabbitRetryTemplateCustomizer> retryTemplateCustomizers, RabbitProperties properties) {
        this.messageConverter = messageConverter;
        this.messageRecoverer = messageRecoverer;
        this.retryTemplateCustomizers = retryTemplateCustomizers;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnThreading(value=Threading.PLATFORM)
    SimpleRabbitListenerContainerFactoryConfigurer simpleRabbitListenerContainerFactoryConfigurer() {
        return this.simpleListenerConfigurer();
    }

    @Bean(name={"simpleRabbitListenerContainerFactoryConfigurer"})
    @ConditionalOnMissingBean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    SimpleRabbitListenerContainerFactoryConfigurer simpleRabbitListenerContainerFactoryConfigurerVirtualThreads() {
        SimpleRabbitListenerContainerFactoryConfigurer configurer = this.simpleListenerConfigurer();
        configurer.setTaskExecutor(new VirtualThreadTaskExecutor("rabbit-simple-"));
        return configurer;
    }

    @Bean(name={"rabbitListenerContainerFactory"})
    @ConditionalOnMissingBean(name={"rabbitListenerContainerFactory"})
    @ConditionalOnProperty(name={"spring.rabbitmq.listener.type"}, havingValue="simple", matchIfMissing=true)
    SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory(SimpleRabbitListenerContainerFactoryConfigurer configurer, ConnectionFactory connectionFactory, ObjectProvider<ContainerCustomizer<SimpleMessageListenerContainer>> simpleContainerCustomizer) {
        SimpleRabbitListenerContainerFactory factory2 = new SimpleRabbitListenerContainerFactory();
        configurer.configure(factory2, connectionFactory);
        simpleContainerCustomizer.ifUnique(arg_0 -> ((SimpleRabbitListenerContainerFactory)factory2).setContainerCustomizer(arg_0));
        return factory2;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnThreading(value=Threading.PLATFORM)
    DirectRabbitListenerContainerFactoryConfigurer directRabbitListenerContainerFactoryConfigurer() {
        return this.directListenerConfigurer();
    }

    @Bean(name={"directRabbitListenerContainerFactoryConfigurer"})
    @ConditionalOnMissingBean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    DirectRabbitListenerContainerFactoryConfigurer directRabbitListenerContainerFactoryConfigurerVirtualThreads() {
        DirectRabbitListenerContainerFactoryConfigurer configurer = this.directListenerConfigurer();
        configurer.setTaskExecutor(new VirtualThreadTaskExecutor("rabbit-direct-"));
        return configurer;
    }

    @Bean(name={"rabbitListenerContainerFactory"})
    @ConditionalOnMissingBean(name={"rabbitListenerContainerFactory"})
    @ConditionalOnProperty(name={"spring.rabbitmq.listener.type"}, havingValue="direct")
    DirectRabbitListenerContainerFactory directRabbitListenerContainerFactory(DirectRabbitListenerContainerFactoryConfigurer configurer, ConnectionFactory connectionFactory, ObjectProvider<ContainerCustomizer<DirectMessageListenerContainer>> directContainerCustomizer) {
        DirectRabbitListenerContainerFactory factory2 = new DirectRabbitListenerContainerFactory();
        configurer.configure(factory2, connectionFactory);
        directContainerCustomizer.ifUnique(arg_0 -> ((DirectRabbitListenerContainerFactory)factory2).setContainerCustomizer(arg_0));
        return factory2;
    }

    private SimpleRabbitListenerContainerFactoryConfigurer simpleListenerConfigurer() {
        SimpleRabbitListenerContainerFactoryConfigurer configurer = new SimpleRabbitListenerContainerFactoryConfigurer(this.properties);
        configurer.setMessageConverter(this.messageConverter.getIfUnique());
        configurer.setMessageRecoverer(this.messageRecoverer.getIfUnique());
        configurer.setRetryTemplateCustomizers(this.retryTemplateCustomizers.orderedStream().toList());
        return configurer;
    }

    private DirectRabbitListenerContainerFactoryConfigurer directListenerConfigurer() {
        DirectRabbitListenerContainerFactoryConfigurer configurer = new DirectRabbitListenerContainerFactoryConfigurer(this.properties);
        configurer.setMessageConverter(this.messageConverter.getIfUnique());
        configurer.setMessageRecoverer(this.messageRecoverer.getIfUnique());
        configurer.setRetryTemplateCustomizers(this.retryTemplateCustomizers.orderedStream().toList());
        return configurer;
    }

    @Configuration(proxyBeanMethods=false)
    @EnableRabbit
    @ConditionalOnMissingBean(name={"org.springframework.amqp.rabbit.config.internalRabbitListenerAnnotationProcessor"})
    static class EnableRabbitConfiguration {
        EnableRabbitConfiguration() {
        }
    }
}

