/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import java.time.Duration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.util.Assert;

public final class DefaultJmsListenerContainerFactoryConfigurer {
    private DestinationResolver destinationResolver;
    private MessageConverter messageConverter;
    private ExceptionListener exceptionListener;
    private JtaTransactionManager transactionManager;
    private JmsProperties jmsProperties;
    private ObservationRegistry observationRegistry;

    void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    void setTransactionManager(JtaTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    void setJmsProperties(JmsProperties jmsProperties) {
        this.jmsProperties = jmsProperties;
    }

    @Deprecated(since="3.3.10", forRemoval=true)
    public void setObservationRegistry(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    public void configure(DefaultJmsListenerContainerFactory factory2, ConnectionFactory connectionFactory) {
        Assert.notNull((Object)factory2, "'factory' must not be null");
        Assert.notNull((Object)connectionFactory, "'connectionFactory' must not be null");
        JmsProperties.Listener listenerProperties = this.jmsProperties.getListener();
        JmsProperties.Listener.Session sessionProperties = listenerProperties.getSession();
        factory2.setConnectionFactory(connectionFactory);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.jmsProperties::isPubSubDomain).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setPubSubDomain(arg_0));
        map.from(this.jmsProperties::isSubscriptionDurable).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setSubscriptionDurable(arg_0));
        map.from(this.jmsProperties::getClientId).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setClientId(arg_0));
        map.from(this.transactionManager).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setTransactionManager(arg_0));
        map.from(this.destinationResolver).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setDestinationResolver(arg_0));
        map.from(this.messageConverter).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setMessageConverter(arg_0));
        map.from(this.exceptionListener).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setExceptionListener(arg_0));
        map.from(sessionProperties.getAcknowledgeMode()::getMode).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setSessionAcknowledgeMode(arg_0));
        if (this.transactionManager == null && sessionProperties.getTransacted() == null) {
            factory2.setSessionTransacted(Boolean.valueOf(true));
        }
        map.from(this.observationRegistry).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setObservationRegistry(arg_0));
        map.from(sessionProperties::getTransacted).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setSessionTransacted(arg_0));
        map.from(listenerProperties::isAutoStartup).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setAutoStartup(arg_0));
        map.from(listenerProperties::formatConcurrency).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setConcurrency(arg_0));
        map.from(listenerProperties::getReceiveTimeout).as(Duration::toMillis).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setReceiveTimeout(arg_0));
        map.from(listenerProperties::getMaxMessagesPerTask).to(arg_0 -> ((DefaultJmsListenerContainerFactory)factory2).setMaxMessagesPerTask(arg_0));
    }
}

