/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jooq;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import javax.sql.DataSource;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;
import org.jooq.TransactionProvider;
import org.jooq.conf.Settings;
import org.jooq.impl.DataSourceConnectionProvider;
import org.jooq.impl.DefaultConfiguration;
import org.jooq.impl.DefaultDSLContext;
import org.jooq.impl.DefaultExecuteListenerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jooq.DefaultConfigurationCustomizer;
import org.springframework.boot.autoconfigure.jooq.ExceptionTranslatorExecuteListener;
import org.springframework.boot.autoconfigure.jooq.JaxbNotAvailableException;
import org.springframework.boot.autoconfigure.jooq.JooqProperties;
import org.springframework.boot.autoconfigure.jooq.SpringTransactionProvider;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

@AutoConfiguration(after={DataSourceAutoConfiguration.class, TransactionAutoConfiguration.class})
@ConditionalOnClass(value={DSLContext.class})
@ConditionalOnBean(value={DataSource.class})
@EnableConfigurationProperties(value={JooqProperties.class})
public class JooqAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ConnectionProvider.class})
    public DataSourceConnectionProvider dataSourceConnectionProvider(DataSource dataSource) {
        return new DataSourceConnectionProvider((DataSource)new TransactionAwareDataSourceProxy(dataSource));
    }

    @Bean
    @ConditionalOnBean(value={PlatformTransactionManager.class})
    @ConditionalOnMissingBean(value={TransactionProvider.class})
    public SpringTransactionProvider transactionProvider(PlatformTransactionManager txManager) {
        return new SpringTransactionProvider(txManager);
    }

    @Bean
    @Order(value=0)
    public DefaultExecuteListenerProvider jooqExceptionTranslatorExecuteListenerProvider(ExceptionTranslatorExecuteListener exceptionTranslatorExecuteListener) {
        return new DefaultExecuteListenerProvider((ExecuteListener)exceptionTranslatorExecuteListener);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionTranslatorExecuteListener jooqExceptionTranslator() {
        return ExceptionTranslatorExecuteListener.DEFAULT;
    }

    @Bean
    @ConditionalOnMissingBean(value={DSLContext.class})
    public DefaultDSLContext dslContext(Configuration configuration) {
        return new DefaultDSLContext(configuration);
    }

    @Bean
    @ConditionalOnMissingBean(value={Configuration.class})
    DefaultConfiguration jooqConfiguration(JooqProperties properties, ConnectionProvider connectionProvider, DataSource dataSource, ObjectProvider<TransactionProvider> transactionProvider, ObjectProvider<ExecuteListenerProvider> executeListenerProviders, ObjectProvider<DefaultConfigurationCustomizer> configurationCustomizers, ObjectProvider<Settings> settingsProvider) {
        DefaultConfiguration configuration = new DefaultConfiguration();
        configuration.set(properties.determineSqlDialect(dataSource));
        configuration.set(connectionProvider);
        transactionProvider.ifAvailable(arg_0 -> ((DefaultConfiguration)configuration).set(arg_0));
        settingsProvider.ifAvailable(arg_0 -> ((DefaultConfiguration)configuration).set(arg_0));
        configuration.set((ExecuteListenerProvider[])executeListenerProviders.orderedStream().toArray(ExecuteListenerProvider[]::new));
        configurationCustomizers.orderedStream().forEach(customizer2 -> customizer2.customize(configuration));
        return configuration;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.jooq.config"})
    @ConditionalOnMissingBean(value={Settings.class})
    Settings settings(JooqProperties properties) throws IOException {
        if (!ClassUtils.isPresent("jakarta.xml.bind.JAXBContext", null)) {
            throw new JaxbNotAvailableException();
        }
        Resource resource = properties.getConfig();
        Assert.state(resource.exists(), () -> "Resource %s set in spring.jooq.config does not exist".formatted(resource));
        try (InputStream stream = resource.getInputStream();){
            Settings settings = new JaxbSettingsLoader().load(stream);
            return settings;
        }
    }

    private static final class JaxbSettingsLoader {
        private JaxbSettingsLoader() {
        }

        private Settings load(InputStream inputStream2) {
            try {
                SAXParser parser = this.createParserFactory().newSAXParser();
                SAXSource source2 = new SAXSource(parser.getXMLReader(), new InputSource(inputStream2));
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Settings.class});
                return (Settings)context.createUnmarshaller().unmarshal((Source)source2, Settings.class).getValue();
            }
            catch (JAXBException | ParserConfigurationException | SAXException ex) {
                throw new IllegalStateException("Failed to unmarshal settings", ex);
            }
        }

        private SAXParserFactory createParserFactory() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
            SAXParserFactory factory2 = SAXParserFactory.newInstance();
            factory2.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory2.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory2.setNamespaceAware(true);
            factory2.setXIncludeAware(false);
            return factory2;
        }
    }
}

