/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.boot.web.servlet.DispatcherType;

@ConfigurationProperties(value="spring.session")
public class SessionProperties {
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration timeout;
    private Servlet servlet = new Servlet();

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout2) {
        this.timeout = timeout2;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public Duration determineTimeout(Supplier<Duration> fallbackTimeout) {
        return this.timeout != null ? this.timeout : fallbackTimeout.get();
    }

    public static class Servlet {
        private int filterOrder = -2147483598;
        private Set<DispatcherType> filterDispatcherTypes = new HashSet<DispatcherType>(Arrays.asList(DispatcherType.ASYNC, DispatcherType.ERROR, DispatcherType.REQUEST));

        public int getFilterOrder() {
            return this.filterOrder;
        }

        public void setFilterOrder(int filterOrder) {
            this.filterOrder = filterOrder;
        }

        public Set<DispatcherType> getFilterDispatcherTypes() {
            return this.filterDispatcherTypes;
        }

        public void setFilterDispatcherTypes(Set<DispatcherType> filterDispatcherTypes) {
            this.filterDispatcherTypes = filterDispatcherTypes;
        }
    }
}

