/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import io.netty.channel.ChannelOption;
import java.time.Duration;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.netty.NettyReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.core.env.Environment;
import reactor.netty.http.server.HttpRequestDecoderSpec;
import reactor.netty.http.server.HttpServer;

public class NettyWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<NettyReactiveWebServerFactory>,
Ordered {
    private final Environment environment;
    private final ServerProperties serverProperties;

    public NettyWebServerFactoryCustomizer(Environment environment2, ServerProperties serverProperties) {
        this.environment = environment2;
        this.serverProperties = serverProperties;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void customize(NettyReactiveWebServerFactory factory2) {
        factory2.setUseForwardHeaders(this.getOrDeduceUseForwardHeaders());
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        ServerProperties.Netty nettyProperties = this.serverProperties.getNetty();
        map.from(nettyProperties::getConnectionTimeout).to(connectionTimeout -> this.customizeConnectionTimeout(factory2, (Duration)connectionTimeout));
        map.from(nettyProperties::getIdleTimeout).to(idleTimeout -> this.customizeIdleTimeout(factory2, (Duration)idleTimeout));
        map.from(nettyProperties::getMaxKeepAliveRequests).to(maxKeepAliveRequests -> this.customizeMaxKeepAliveRequests(factory2, (int)maxKeepAliveRequests));
        if (this.serverProperties.getHttp2() != null && this.serverProperties.getHttp2().isEnabled()) {
            map.from(this.serverProperties.getMaxHttpRequestHeaderSize()).to(size -> this.customizeHttp2MaxHeaderSize(factory2, size.toBytes()));
        }
        this.customizeRequestDecoder(factory2, map);
    }

    private boolean getOrDeduceUseForwardHeaders() {
        if (this.serverProperties.getForwardHeadersStrategy() == null) {
            CloudPlatform platform = CloudPlatform.getActive(this.environment);
            return platform != null && platform.isUsingForwardHeaders();
        }
        return this.serverProperties.getForwardHeadersStrategy().equals((Object)ServerProperties.ForwardHeadersStrategy.NATIVE);
    }

    private void customizeConnectionTimeout(NettyReactiveWebServerFactory factory2, Duration connectionTimeout) {
        factory2.addServerCustomizers(httpServer -> (HttpServer)httpServer.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectionTimeout.toMillis())));
    }

    private void customizeRequestDecoder(NettyReactiveWebServerFactory factory2, PropertyMapper propertyMapper) {
        factory2.addServerCustomizers(httpServer -> httpServer.httpRequestDecoder(httpRequestDecoderSpec -> {
            propertyMapper.from(this.serverProperties.getMaxHttpRequestHeaderSize()).to(maxHttpRequestHeader -> httpRequestDecoderSpec.maxHeaderSize((int)maxHttpRequestHeader.toBytes()));
            ServerProperties.Netty nettyProperties = this.serverProperties.getNetty();
            propertyMapper.from(nettyProperties.getMaxInitialLineLength()).to(maxInitialLineLength -> httpRequestDecoderSpec.maxInitialLineLength((int)maxInitialLineLength.toBytes()));
            propertyMapper.from(nettyProperties.getH2cMaxContentLength()).to(h2cMaxContentLength -> httpRequestDecoderSpec.h2cMaxContentLength((int)h2cMaxContentLength.toBytes()));
            propertyMapper.from(nettyProperties.getInitialBufferSize()).to(initialBufferSize -> httpRequestDecoderSpec.initialBufferSize((int)initialBufferSize.toBytes()));
            propertyMapper.from(nettyProperties.isValidateHeaders()).to(arg_0 -> ((HttpRequestDecoderSpec)httpRequestDecoderSpec).validateHeaders(arg_0));
            return httpRequestDecoderSpec;
        }));
    }

    private void customizeIdleTimeout(NettyReactiveWebServerFactory factory2, Duration idleTimeout) {
        factory2.addServerCustomizers(httpServer -> httpServer.idleTimeout(idleTimeout));
    }

    private void customizeMaxKeepAliveRequests(NettyReactiveWebServerFactory factory2, int maxKeepAliveRequests) {
        factory2.addServerCustomizers(httpServer -> httpServer.maxKeepAliveRequests(maxKeepAliveRequests));
    }

    private void customizeHttp2MaxHeaderSize(NettyReactiveWebServerFactory factory2, long size) {
        factory2.addServerCustomizers(httpServer -> httpServer.http2Settings(settings -> settings.maxHeaderListSize(size)));
    }
}

