/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.springframework.boot.context.properties.bind.AggregateBinder;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ResolvableType;

class MapBinder
extends AggregateBinder<Map<Object, Object>> {
    private static final Bindable<Map<String, String>> STRING_STRING_MAP = Bindable.mapOf(String.class, String.class);

    MapBinder(Binder.Context context) {
        super(context);
    }

    @Override
    protected boolean isAllowRecursiveBinding(ConfigurationPropertySource source2) {
        return true;
    }

    @Override
    protected Object bindAggregate(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder elementBinder) {
        Bindable<?> resolvedTarget = this.resolveTarget(target);
        boolean hasDescendants = this.hasDescendants(name);
        if (!hasDescendants && !ConfigurationPropertyName.EMPTY.equals(name)) {
            for (ConfigurationPropertySource source2 : this.getContext().getSources()) {
                ConfigurationProperty property = source2.getConfigurationProperty(name);
                if (property == null) continue;
                this.getContext().setConfigurationProperty(property);
                Object result = this.getContext().getPlaceholdersResolver().resolvePlaceholders(property.getValue());
                return this.getContext().getConverter().convert(result, target);
            }
        }
        Map<Object, Object> map = this.createMap(target);
        for (ConfigurationPropertySource source3 : this.getContext().getSources()) {
            if (!ConfigurationPropertyName.EMPTY.equals(name)) {
                source3 = source3.filter(name::isAncestorOf);
            }
            new EntryBinder(name, resolvedTarget, elementBinder).bindEntries(source3, map);
        }
        return map.isEmpty() ? null : map;
    }

    private Map<Object, Object> createMap(Bindable<?> target) {
        Class<Map> mapType;
        Class clazz = mapType = target.getValue() != null ? Map.class : target.getType().resolve(Object.class);
        if (EnumMap.class.isAssignableFrom(mapType)) {
            Class<?> keyType = target.getType().asMap().resolveGeneric(0);
            return CollectionFactory.createMap(mapType, keyType, 0);
        }
        return CollectionFactory.createMap(mapType, 0);
    }

    private boolean hasDescendants(ConfigurationPropertyName name) {
        for (ConfigurationPropertySource source2 : this.getContext().getSources()) {
            if (source2.containsDescendantOf(name) != ConfigurationPropertyState.PRESENT) continue;
            return true;
        }
        return false;
    }

    private Bindable<?> resolveTarget(Bindable<?> target) {
        Class<?> type = target.getType().resolve(Object.class);
        if (Properties.class.isAssignableFrom(type)) {
            return STRING_STRING_MAP;
        }
        return target;
    }

    @Override
    protected Map<Object, Object> merge(Supplier<Map<Object, Object>> existing, Map<Object, Object> additional) {
        Map<Object, Object> existingMap = this.getExistingIfPossible(existing);
        if (existingMap == null) {
            return additional;
        }
        try {
            existingMap.putAll(additional);
            return this.copyIfPossible(existingMap);
        }
        catch (UnsupportedOperationException ex) {
            Map<Object, Object> result = this.createNewMap(additional.getClass(), existingMap);
            result.putAll(additional);
            return result;
        }
    }

    private Map<Object, Object> getExistingIfPossible(Supplier<Map<Object, Object>> existing) {
        try {
            return existing.get();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Map<Object, Object> copyIfPossible(Map<Object, Object> map) {
        try {
            return this.createNewMap(map.getClass(), map);
        }
        catch (Exception ex) {
            return map;
        }
    }

    private Map<Object, Object> createNewMap(Class<?> mapClass, Map<Object, Object> map) {
        Map<Object, Object> result = CollectionFactory.createMap(mapClass, map.size());
        result.putAll(map);
        return result;
    }

    private class EntryBinder {
        private final ConfigurationPropertyName root;
        private final AggregateElementBinder elementBinder;
        private final ResolvableType mapType;
        private final ResolvableType keyType;
        private final ResolvableType valueType;
        private final Class<?> resolvedValueType;
        private final boolean valueTreatedAsNestedMap;
        private final Bindable<Object> bindableMapType;
        private final Bindable<Object> bindableValueType;

        EntryBinder(ConfigurationPropertyName root, Bindable<?> target, AggregateElementBinder elementBinder) {
            this.root = root;
            this.elementBinder = elementBinder;
            this.mapType = target.getType().asMap();
            this.keyType = this.mapType.getGeneric(0);
            this.valueType = this.mapType.getGeneric(1);
            this.resolvedValueType = this.valueType.resolve(Object.class);
            this.valueTreatedAsNestedMap = Object.class.equals(this.resolvedValueType);
            this.bindableMapType = Bindable.of(this.mapType);
            this.bindableValueType = Bindable.of(this.valueType);
        }

        void bindEntries(ConfigurationPropertySource source2, Map<Object, Object> map) {
            if (source2 instanceof IterableConfigurationPropertySource) {
                IterableConfigurationPropertySource iterableSource = (IterableConfigurationPropertySource)source2;
                for (ConfigurationPropertyName name : iterableSource) {
                    ConfigurationPropertyName entryName = this.getEntryName(source2, name);
                    Object key = MapBinder.this.getContext().getConverter().convert((Object)this.getKeyName(entryName), this.keyType, new Annotation[0]);
                    Bindable<?> valueBindable = this.getValueBindable(name);
                    map.computeIfAbsent(key, k -> this.elementBinder.bind(entryName, valueBindable));
                }
            }
        }

        private Bindable<?> getValueBindable(ConfigurationPropertyName name) {
            return !this.isParentOf(name) && this.valueTreatedAsNestedMap ? this.bindableMapType : this.bindableValueType;
        }

        private ConfigurationPropertyName getEntryName(ConfigurationPropertySource source2, ConfigurationPropertyName name) {
            if (Collection.class.isAssignableFrom(this.resolvedValueType) || this.valueType.isArray()) {
                return this.chopNameAtNumericIndex(name);
            }
            if (!(this.isParentOf(name) || !this.valueTreatedAsNestedMap && this.isScalarValue(source2, name))) {
                return name.chop(this.root.getNumberOfElements() + 1);
            }
            return name;
        }

        private boolean isParentOf(ConfigurationPropertyName name) {
            return this.root.isParentOf(name);
        }

        private ConfigurationPropertyName chopNameAtNumericIndex(ConfigurationPropertyName name) {
            int start = this.root.getNumberOfElements() + 1;
            int size = name.getNumberOfElements();
            for (int i2 = start; i2 < size; ++i2) {
                if (!name.isNumericIndex(i2)) continue;
                return name.chop(i2);
            }
            return name;
        }

        private boolean isScalarValue(ConfigurationPropertySource source2, ConfigurationPropertyName name) {
            Class<?> resolved = this.valueType.resolve(Object.class);
            if (!resolved.getName().startsWith("java.lang") && !resolved.isEnum()) {
                return false;
            }
            ConfigurationProperty property = source2.getConfigurationProperty(name);
            if (property == null) {
                return false;
            }
            Object value = property.getValue();
            value = MapBinder.this.getContext().getPlaceholdersResolver().resolvePlaceholders(value);
            return MapBinder.this.getContext().getConverter().canConvert(value, this.valueType, new Annotation[0]);
        }

        private String getKeyName(ConfigurationPropertyName name) {
            StringBuilder result = new StringBuilder();
            for (int i2 = this.root.getNumberOfElements(); i2 < name.getNumberOfElements(); ++i2) {
                if (!result.isEmpty()) {
                    result.append('.');
                }
                result.append(name.getElement(i2, ConfigurationPropertyName.Form.ORIGINAL));
            }
            return result.toString();
        }
    }
}

