/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyNameException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ConfigurationPropertyName
implements Comparable<ConfigurationPropertyName> {
    private static final String EMPTY_STRING = "";
    public static final ConfigurationPropertyName EMPTY = new ConfigurationPropertyName(Elements.EMPTY);
    private final Elements elements;
    private final CharSequence[] uniformElements;
    private int hashCode;
    private String[] string = new String[ToStringFormat.values().length];
    private Boolean hasDashedElement;
    private ConfigurationPropertyName systemEnvironmentLegacyName;

    private ConfigurationPropertyName(Elements elements) {
        this.elements = elements;
        this.uniformElements = new CharSequence[elements.getSize()];
    }

    public boolean isEmpty() {
        return this.elements.getSize() == 0;
    }

    public boolean isLastElementIndexed() {
        int size = this.getNumberOfElements();
        return size > 0 && this.isIndexed(size - 1);
    }

    public boolean hasIndexedElement() {
        for (int i2 = 0; i2 < this.getNumberOfElements(); ++i2) {
            if (!this.isIndexed(i2)) continue;
            return true;
        }
        return false;
    }

    boolean isIndexed(int elementIndex) {
        return this.elements.getType(elementIndex).isIndexed();
    }

    public boolean isNumericIndex(int elementIndex) {
        return this.elements.getType(elementIndex) == ElementType.NUMERICALLY_INDEXED;
    }

    public String getLastElement(Form form) {
        int size = this.getNumberOfElements();
        return size != 0 ? this.getElement(size - 1, form) : EMPTY_STRING;
    }

    public String getElement(int elementIndex, Form form) {
        CharSequence element = this.elements.get(elementIndex);
        ElementType type = this.elements.getType(elementIndex);
        if (type.isIndexed()) {
            return element.toString();
        }
        if (form == Form.ORIGINAL) {
            if (type != ElementType.NON_UNIFORM) {
                return element.toString();
            }
            return this.convertToOriginalForm(element).toString();
        }
        if (form == Form.DASHED) {
            if (type == ElementType.UNIFORM || type == ElementType.DASHED) {
                return element.toString();
            }
            return this.convertToDashedElement(element).toString();
        }
        CharSequence uniformElement = this.uniformElements[elementIndex];
        if (uniformElement == null) {
            uniformElement = type != ElementType.UNIFORM ? this.convertToUniformElement(element) : element;
            this.uniformElements[elementIndex] = uniformElement.toString();
        }
        return uniformElement.toString();
    }

    private CharSequence convertToOriginalForm(CharSequence element) {
        return this.convertElement(element, false, (ch, i2) -> ch == '_' || ElementsParser.isValidChar(Character.toLowerCase(ch), i2));
    }

    private CharSequence convertToDashedElement(CharSequence element) {
        return this.convertElement(element, true, ElementsParser::isValidChar);
    }

    private CharSequence convertToUniformElement(CharSequence element) {
        return this.convertElement(element, true, (ch, i2) -> ElementsParser.isAlphaNumeric(ch));
    }

    private CharSequence convertElement(CharSequence element, boolean lowercase, ElementCharPredicate filter2) {
        StringBuilder result = new StringBuilder(element.length());
        for (int i2 = 0; i2 < element.length(); ++i2) {
            char ch;
            char c = ch = lowercase ? Character.toLowerCase(element.charAt(i2)) : element.charAt(i2);
            if (!filter2.test(ch, i2)) continue;
            result.append(ch);
        }
        return result;
    }

    public int getNumberOfElements() {
        return this.elements.getSize();
    }

    public ConfigurationPropertyName append(String suffix) {
        if (!StringUtils.hasLength(suffix)) {
            return this;
        }
        Elements additionalElements = ConfigurationPropertyName.probablySingleElementOf(suffix);
        return new ConfigurationPropertyName(this.elements.append(additionalElements));
    }

    public ConfigurationPropertyName append(ConfigurationPropertyName suffix) {
        if (suffix == null) {
            return this;
        }
        return new ConfigurationPropertyName(this.elements.append(suffix.elements));
    }

    public ConfigurationPropertyName getParent() {
        int numberOfElements = this.getNumberOfElements();
        return numberOfElements <= 1 ? EMPTY : this.chop(numberOfElements - 1);
    }

    public ConfigurationPropertyName chop(int size) {
        if (size >= this.getNumberOfElements()) {
            return this;
        }
        return new ConfigurationPropertyName(this.elements.chop(size));
    }

    public ConfigurationPropertyName subName(int offset) {
        if (offset == 0) {
            return this;
        }
        if (offset == this.getNumberOfElements()) {
            return EMPTY;
        }
        if (offset < 0 || offset > this.getNumberOfElements()) {
            throw new IndexOutOfBoundsException("Offset: " + offset + ", NumberOfElements: " + this.getNumberOfElements());
        }
        return new ConfigurationPropertyName(this.elements.subElements(offset));
    }

    public boolean isParentOf(ConfigurationPropertyName name) {
        Assert.notNull((Object)name, "'name' must not be null");
        if (this.getNumberOfElements() != name.getNumberOfElements() - 1) {
            return false;
        }
        return this.isAncestorOf(name);
    }

    public boolean isAncestorOf(ConfigurationPropertyName name) {
        Assert.notNull((Object)name, "'name' must not be null");
        if (this.getNumberOfElements() >= name.getNumberOfElements()) {
            return false;
        }
        return this.endsWithElementsEqualTo(name);
    }

    @Override
    public int compareTo(ConfigurationPropertyName other) {
        return this.compare(this, other);
    }

    private int compare(ConfigurationPropertyName n1, ConfigurationPropertyName n2) {
        int l1 = n1.getNumberOfElements();
        int l2 = n2.getNumberOfElements();
        int i1 = 0;
        int i2 = 0;
        while (i1 < l1 || i2 < l2) {
            try {
                ElementType type2;
                String e2;
                ElementType type1;
                String e1 = i1 < l1 ? n1.getElement(i1++, Form.UNIFORM) : null;
                int result = this.compare(e1, type1 = i1 < l1 ? n1.elements.getType(i1) : null, e2 = i2 < l2 ? n2.getElement(i2++, Form.UNIFORM) : null, type2 = i2 < l2 ? n2.elements.getType(i2) : null);
                if (result == 0) continue;
                return result;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new RuntimeException(ex);
            }
        }
        return 0;
    }

    private int compare(String e1, ElementType type1, String e2, ElementType type2) {
        if (e1 == null) {
            return -1;
        }
        if (e2 == null) {
            return 1;
        }
        int result = Boolean.compare(type2.isIndexed(), type1.isIndexed());
        if (result != 0) {
            return result;
        }
        if (type1 == ElementType.NUMERICALLY_INDEXED && type2 == ElementType.NUMERICALLY_INDEXED) {
            long v1 = Long.parseLong(e1);
            long v2 = Long.parseLong(e2);
            return Long.compare(v1, v2);
        }
        return e1.compareTo(e2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConfigurationPropertyName other = (ConfigurationPropertyName)obj;
        if (this.getNumberOfElements() != other.getNumberOfElements()) {
            return false;
        }
        if (this.elements.canShortcutWithSource(ElementType.UNIFORM) && other.elements.canShortcutWithSource(ElementType.UNIFORM)) {
            return this.toString().equals(other.toString());
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (this.toStringMatches(this.toString(), other.toString())) {
            return true;
        }
        return this.endsWithElementsEqualTo(other);
    }

    private boolean toStringMatches(String s1, String s2) {
        return s1.hashCode() == s2.hashCode() && s1.equals(s2);
    }

    private boolean endsWithElementsEqualTo(ConfigurationPropertyName name) {
        for (int i2 = this.elements.getSize() - 1; i2 >= 0; --i2) {
            if (!this.elementDiffers(this.elements, name.elements, i2)) continue;
            return false;
        }
        return true;
    }

    private boolean elementDiffers(Elements e1, Elements e2, int i2) {
        ElementType type1 = e1.getType(i2);
        ElementType type2 = e2.getType(i2);
        if (type1.allowsFastEqualityCheck() && type2.allowsFastEqualityCheck()) {
            return !this.fastElementEquals(e1, e2, i2);
        }
        if (type1.allowsDashIgnoringEqualityCheck() && type2.allowsDashIgnoringEqualityCheck()) {
            return !this.dashIgnoringElementEquals(e1, e2, i2);
        }
        return !this.defaultElementEquals(e1, e2, i2);
    }

    private boolean fastElementEquals(Elements e1, Elements e2, int i2) {
        int length2;
        int length1 = e1.getLength(i2);
        if (length1 == (length2 = e2.getLength(i2))) {
            int i1 = 0;
            while (length1-- != 0) {
                char ch2;
                char ch1 = e1.charAt(i2, i1);
                if (ch1 != (ch2 = e2.charAt(i2, i1))) {
                    return false;
                }
                ++i1;
            }
            return true;
        }
        return false;
    }

    private boolean dashIgnoringElementEquals(Elements e1, Elements e2, int i2) {
        int l1 = e1.getLength(i2);
        int l2 = e2.getLength(i2);
        int i1 = 0;
        int i22 = 0;
        while (i1 < l1) {
            if (i22 >= l2) {
                return this.remainderIsDashes(e1, i2, i1);
            }
            char ch1 = e1.charAt(i2, i1);
            char ch2 = e2.charAt(i2, i22);
            if (ch1 == '-') {
                ++i1;
                continue;
            }
            if (ch2 == '-') {
                ++i22;
                continue;
            }
            if (ch1 != ch2) {
                return false;
            }
            ++i1;
            ++i22;
        }
        if (i22 < l2) {
            if (e2.getType(i2).isIndexed()) {
                return false;
            }
            do {
                char ch2;
                if ((ch2 = e2.charAt(i2, i22++)) == '-') continue;
                return false;
            } while (i22 < l2);
        }
        return true;
    }

    private boolean defaultElementEquals(Elements e1, Elements e2, int i2) {
        int l1 = e1.getLength(i2);
        int l2 = e2.getLength(i2);
        boolean indexed1 = e1.getType(i2).isIndexed();
        boolean indexed2 = e2.getType(i2).isIndexed();
        int i1 = 0;
        int i22 = 0;
        while (i1 < l1) {
            char ch2;
            if (i22 >= l2) {
                return this.remainderIsNotAlphanumeric(e1, i2, i1);
            }
            char ch1 = indexed1 ? e1.charAt(i2, i1) : Character.toLowerCase(e1.charAt(i2, i1));
            char c = ch2 = indexed2 ? e2.charAt(i2, i22) : Character.toLowerCase(e2.charAt(i2, i22));
            if (!indexed1 && !ElementsParser.isAlphaNumeric(ch1)) {
                ++i1;
                continue;
            }
            if (!indexed2 && !ElementsParser.isAlphaNumeric(ch2)) {
                ++i22;
                continue;
            }
            if (ch1 != ch2) {
                return false;
            }
            ++i1;
            ++i22;
        }
        if (i22 < l2) {
            return this.remainderIsNotAlphanumeric(e2, i2, i22);
        }
        return true;
    }

    private boolean remainderIsNotAlphanumeric(Elements elements, int element, int index) {
        if (elements.getType(element).isIndexed()) {
            return false;
        }
        int length = elements.getLength(element);
        do {
            char c;
            if (!ElementsParser.isAlphaNumeric(c = Character.toLowerCase(elements.charAt(element, index++)))) continue;
            return false;
        } while (index < length);
        return true;
    }

    private boolean remainderIsDashes(Elements elements, int element, int index) {
        if (elements.getType(element).isIndexed()) {
            return false;
        }
        int length = elements.getLength(element);
        do {
            char c;
            if ((c = elements.charAt(element, index++)) == '-') continue;
            return false;
        } while (index < length);
        return true;
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        Elements elements = this.elements;
        if (hashCode == 0 && elements.getSize() != 0) {
            for (int elementIndex = 0; elementIndex < elements.getSize(); ++elementIndex) {
                hashCode = 31 * hashCode + elements.hashCode(elementIndex);
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    ConfigurationPropertyName asSystemEnvironmentLegacyName() {
        ConfigurationPropertyName name = this.systemEnvironmentLegacyName;
        if (name == null) {
            name = ConfigurationPropertyName.ofIfValid(this.buildSimpleToString('.', i2 -> this.getElement(i2, Form.DASHED).replace('-', '.')));
            this.systemEnvironmentLegacyName = name != null ? name : EMPTY;
        }
        return name != EMPTY ? name : null;
    }

    public String toString() {
        return this.toString(ToStringFormat.DEFAULT, false);
    }

    String toString(ToStringFormat format, boolean upperCase) {
        String string = this.string[format.ordinal()];
        if (string == null) {
            this.string[format.ordinal()] = string = this.buildToString(format);
        }
        return !upperCase ? string : string.toUpperCase(Locale.ENGLISH);
    }

    private String buildToString(ToStringFormat format) {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case ToStringFormat.DEFAULT -> this.buildDefaultToString();
            case ToStringFormat.SYSTEM_ENVIRONMENT -> this.buildSimpleToString('_', i2 -> this.getElement(i2, Form.UNIFORM));
            case ToStringFormat.LEGACY_SYSTEM_ENVIRONMENT -> this.buildSimpleToString('_', i2 -> this.getElement(i2, Form.ORIGINAL).replace('-', '_'));
        };
    }

    private String buildDefaultToString() {
        if (this.elements.canShortcutWithSource(ElementType.UNIFORM, ElementType.DASHED)) {
            return this.elements.getSource().toString();
        }
        int elements = this.getNumberOfElements();
        StringBuilder result = new StringBuilder(elements * 8);
        for (int i2 = 0; i2 < elements; ++i2) {
            boolean indexed = this.isIndexed(i2);
            if (!result.isEmpty() && !indexed) {
                result.append('.');
            }
            if (indexed) {
                result.append('[');
                result.append(this.getElement(i2, Form.ORIGINAL));
                result.append(']');
                continue;
            }
            result.append(this.getElement(i2, Form.DASHED));
        }
        return result.toString();
    }

    private String buildSimpleToString(char joinChar, IntFunction<String> elementConverter) {
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < this.getNumberOfElements(); ++i2) {
            if (!result.isEmpty()) {
                result.append(joinChar);
            }
            result.append(elementConverter.apply(i2));
        }
        return result.toString();
    }

    boolean hasDashedElement() {
        Boolean hasDashedElement = this.hasDashedElement;
        if (hasDashedElement != null) {
            return hasDashedElement;
        }
        for (int i2 = 0; i2 < this.getNumberOfElements(); ++i2) {
            if (this.getElement(i2, Form.DASHED).indexOf(45) == -1) continue;
            this.hasDashedElement = true;
            return true;
        }
        this.hasDashedElement = false;
        return false;
    }

    public static boolean isValid(CharSequence name) {
        return ConfigurationPropertyName.of(name, true) != null;
    }

    public static ConfigurationPropertyName of(CharSequence name) {
        return ConfigurationPropertyName.of(name, false);
    }

    public static ConfigurationPropertyName ofIfValid(CharSequence name) {
        return ConfigurationPropertyName.of(name, true);
    }

    static ConfigurationPropertyName of(CharSequence name, boolean returnNullIfInvalid) {
        Elements elements = ConfigurationPropertyName.elementsOf(name, returnNullIfInvalid);
        return elements != null ? new ConfigurationPropertyName(elements) : null;
    }

    private static Elements probablySingleElementOf(CharSequence name) {
        return ConfigurationPropertyName.elementsOf(name, false, 1);
    }

    private static Elements elementsOf(CharSequence name, boolean returnNullIfInvalid) {
        return ConfigurationPropertyName.elementsOf(name, returnNullIfInvalid, 6);
    }

    private static Elements elementsOf(CharSequence name, boolean returnNullIfInvalid, int parserCapacity) {
        if (name == null) {
            Assert.isTrue(returnNullIfInvalid, "'name' must not be null");
            return null;
        }
        if (name.isEmpty()) {
            return Elements.EMPTY;
        }
        if (name.charAt(0) == '.' || name.charAt(name.length() - 1) == '.') {
            if (returnNullIfInvalid) {
                return null;
            }
            throw new InvalidConfigurationPropertyNameException(name, Collections.singletonList(Character.valueOf('.')));
        }
        Elements elements = new ElementsParser(name, '.', parserCapacity).parse();
        for (int i2 = 0; i2 < elements.getSize(); ++i2) {
            if (elements.getType(i2) != ElementType.NON_UNIFORM) continue;
            if (returnNullIfInvalid) {
                return null;
            }
            throw new InvalidConfigurationPropertyNameException(name, ConfigurationPropertyName.getInvalidChars(elements, i2));
        }
        return elements;
    }

    private static List<Character> getInvalidChars(Elements elements, int index) {
        ArrayList<Character> invalidChars = new ArrayList<Character>();
        for (int charIndex = 0; charIndex < elements.getLength(index); ++charIndex) {
            char ch = elements.charAt(index, charIndex);
            if (ElementsParser.isValidChar(ch, charIndex)) continue;
            invalidChars.add(Character.valueOf(ch));
        }
        return invalidChars;
    }

    public static ConfigurationPropertyName adapt(CharSequence name, char separator) {
        return ConfigurationPropertyName.adapt(name, separator, null);
    }

    static ConfigurationPropertyName adapt(CharSequence name, char separator, Function<CharSequence, CharSequence> elementValueProcessor) {
        Assert.notNull((Object)name, "Name must not be null");
        if (name.isEmpty()) {
            return EMPTY;
        }
        Elements elements = new ElementsParser(name, separator).parse(elementValueProcessor);
        if (elements.getSize() == 0) {
            return EMPTY;
        }
        return new ConfigurationPropertyName(elements);
    }

    static enum ToStringFormat {
        DEFAULT,
        SYSTEM_ENVIRONMENT,
        LEGACY_SYSTEM_ENVIRONMENT;

    }

    private static class Elements {
        private static final int[] NO_POSITION = new int[0];
        private static final ElementType[] NO_TYPE = new ElementType[0];
        public static final Elements EMPTY = new Elements("", 0, NO_POSITION, NO_POSITION, NO_TYPE, null, null);
        private final CharSequence source;
        private final int size;
        private final int[] start;
        private final int[] end;
        private final ElementType[] type;
        private final int[] hashCode;
        private final CharSequence[] resolved;

        Elements(CharSequence source2, int size, int[] start, int[] end, ElementType[] type, int[] hashCode, CharSequence[] resolved) {
            this.source = source2;
            this.size = size;
            this.start = start;
            this.end = end;
            this.type = type;
            this.hashCode = hashCode != null ? hashCode : new int[size];
            this.resolved = resolved;
        }

        Elements append(Elements additional) {
            int size = this.size + additional.size;
            ElementType[] type = new ElementType[size];
            int[] hashCode = new int[size];
            System.arraycopy(this.type, 0, type, 0, this.size);
            System.arraycopy(additional.type, 0, type, this.size, additional.size);
            System.arraycopy(this.hashCode, 0, hashCode, 0, this.size);
            System.arraycopy(additional.hashCode, 0, hashCode, this.size, additional.size);
            CharSequence[] resolved = this.newResolved(0, size);
            for (int i2 = 0; i2 < additional.size; ++i2) {
                resolved[this.size + i2] = additional.get(i2);
            }
            return new Elements(this.source, size, this.start, this.end, type, hashCode, resolved);
        }

        Elements chop(int size) {
            CharSequence[] resolved = this.newResolved(0, size);
            return new Elements(this.source, size, this.start, this.end, this.type, this.hashCode, resolved);
        }

        Elements subElements(int offset) {
            int size = this.size - offset;
            CharSequence[] resolved = this.newResolved(offset, size);
            int[] start = new int[size];
            System.arraycopy(this.start, offset, start, 0, size);
            int[] end = new int[size];
            System.arraycopy(this.end, offset, end, 0, size);
            ElementType[] type = new ElementType[size];
            System.arraycopy(this.type, offset, type, 0, size);
            int[] hashCode = new int[size];
            System.arraycopy(this.hashCode, offset, hashCode, 0, size);
            return new Elements(this.source, size, start, end, type, hashCode, resolved);
        }

        private CharSequence[] newResolved(int offset, int size) {
            CharSequence[] resolved = new CharSequence[size];
            if (this.resolved != null) {
                System.arraycopy(this.resolved, offset, resolved, 0, Math.min(size, this.size));
            }
            return resolved;
        }

        int getSize() {
            return this.size;
        }

        CharSequence get(int index) {
            if (this.resolved != null && this.resolved[index] != null) {
                return this.resolved[index];
            }
            int start = this.start[index];
            int end = this.end[index];
            return this.source.subSequence(start, end);
        }

        int getLength(int index) {
            if (this.resolved != null && this.resolved[index] != null) {
                return this.resolved[index].length();
            }
            int start = this.start[index];
            int end = this.end[index];
            return end - start;
        }

        char charAt(int index, int charIndex) {
            if (this.resolved != null && this.resolved[index] != null) {
                return this.resolved[index].charAt(charIndex);
            }
            int start = this.start[index];
            return this.source.charAt(start + charIndex);
        }

        ElementType getType(int index) {
            return this.type[index];
        }

        int hashCode(int index) {
            int hashCode = this.hashCode[index];
            if (hashCode == 0) {
                boolean indexed = this.getType(index).isIndexed();
                int length = this.getLength(index);
                for (int i2 = 0; i2 < length; ++i2) {
                    char ch = this.charAt(index, i2);
                    if (!indexed) {
                        ch = Character.toLowerCase(ch);
                    }
                    if (!ElementsParser.isAlphaNumeric(ch)) continue;
                    hashCode = 31 * hashCode + ch;
                }
                this.hashCode[index] = hashCode;
            }
            return hashCode;
        }

        CharSequence getSource() {
            return this.source;
        }

        boolean canShortcutWithSource(ElementType requiredType) {
            return this.canShortcutWithSource(requiredType, requiredType);
        }

        boolean canShortcutWithSource(ElementType requiredType, ElementType alternativeType) {
            if (this.resolved != null) {
                return false;
            }
            for (int i2 = 0; i2 < this.size; ++i2) {
                ElementType type = this.type[i2];
                if (type != requiredType && type != alternativeType) {
                    return false;
                }
                if (i2 <= 0 || this.end[i2 - 1] + 1 == this.start[i2]) continue;
                return false;
            }
            return true;
        }
    }

    private static enum ElementType {
        EMPTY(false),
        UNIFORM(false),
        DASHED(false),
        NON_UNIFORM(false),
        INDEXED(true),
        NUMERICALLY_INDEXED(true);

        private final boolean indexed;

        private ElementType(boolean indexed) {
            this.indexed = indexed;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        public boolean allowsFastEqualityCheck() {
            return this == UNIFORM || this == NUMERICALLY_INDEXED;
        }

        public boolean allowsDashIgnoringEqualityCheck() {
            return this.allowsFastEqualityCheck() || this == DASHED;
        }
    }

    public static enum Form {
        ORIGINAL,
        DASHED,
        UNIFORM;

    }

    private static interface ElementCharPredicate {
        public boolean test(char var1, int var2);
    }

    private static class ElementsParser {
        private static final int DEFAULT_CAPACITY = 6;
        private final CharSequence source;
        private final char separator;
        private int size;
        private int[] start;
        private int[] end;
        private ElementType[] type;
        private CharSequence[] resolved;

        ElementsParser(CharSequence source2, char separator) {
            this(source2, separator, 6);
        }

        ElementsParser(CharSequence source2, char separator, int capacity) {
            this.source = source2;
            this.separator = separator;
            this.start = new int[capacity];
            this.end = new int[capacity];
            this.type = new ElementType[capacity];
        }

        Elements parse() {
            return this.parse(null);
        }

        Elements parse(Function<CharSequence, CharSequence> valueProcessor) {
            int length = this.source.length();
            int openBracketCount = 0;
            int start = 0;
            ElementType type = ElementType.EMPTY;
            for (int i2 = 0; i2 < length; ++i2) {
                char ch = this.source.charAt(i2);
                if (ch == '[') {
                    if (openBracketCount == 0) {
                        this.add(start, i2, type, valueProcessor);
                        start = i2 + 1;
                        type = ElementType.NUMERICALLY_INDEXED;
                    }
                    ++openBracketCount;
                    continue;
                }
                if (ch == ']') {
                    if (--openBracketCount != 0) continue;
                    this.add(start, i2, type, valueProcessor);
                    start = i2 + 1;
                    type = ElementType.EMPTY;
                    continue;
                }
                if (!type.isIndexed() && ch == this.separator) {
                    this.add(start, i2, type, valueProcessor);
                    start = i2 + 1;
                    type = ElementType.EMPTY;
                    continue;
                }
                type = this.updateType(type, ch, i2 - start);
            }
            if (openBracketCount != 0) {
                type = ElementType.NON_UNIFORM;
            }
            this.add(start, length, type, valueProcessor);
            return new Elements(this.source, this.size, this.start, this.end, this.type, null, this.resolved);
        }

        private ElementType updateType(ElementType existingType, char ch, int index) {
            if (existingType.isIndexed()) {
                if (existingType == ElementType.NUMERICALLY_INDEXED && !ElementsParser.isNumeric(ch)) {
                    return ElementType.INDEXED;
                }
                return existingType;
            }
            if (existingType == ElementType.EMPTY && ElementsParser.isValidChar(ch, index)) {
                return index == 0 ? ElementType.UNIFORM : ElementType.NON_UNIFORM;
            }
            if (existingType == ElementType.UNIFORM && ch == '-') {
                return ElementType.DASHED;
            }
            if (!ElementsParser.isValidChar(ch, index)) {
                if (existingType == ElementType.EMPTY && !ElementsParser.isValidChar(Character.toLowerCase(ch), index)) {
                    return ElementType.EMPTY;
                }
                return ElementType.NON_UNIFORM;
            }
            return existingType;
        }

        private void add(int start, int end, ElementType type, Function<CharSequence, CharSequence> valueProcessor) {
            if (end - start < 1 || type == ElementType.EMPTY) {
                return;
            }
            if (this.start.length == this.size) {
                this.start = this.expand(this.start);
                this.end = this.expand(this.end);
                this.type = this.expand(this.type);
                this.resolved = this.expand(this.resolved);
            }
            if (valueProcessor != null) {
                CharSequence resolved;
                Elements resolvedElements;
                if (this.resolved == null) {
                    this.resolved = new CharSequence[this.start.length];
                }
                Assert.state((resolvedElements = new ElementsParser(resolved = valueProcessor.apply(this.source.subSequence(start, end)), '.').parse()).getSize() == 1, "Resolved element must not contain multiple elements");
                this.resolved[this.size] = resolvedElements.get(0);
                type = resolvedElements.getType(0);
            }
            this.start[this.size] = start;
            this.end[this.size] = end;
            this.type[this.size] = type;
            ++this.size;
        }

        private int[] expand(int[] src) {
            int[] dest = new int[src.length + 6];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        private ElementType[] expand(ElementType[] src) {
            ElementType[] dest = new ElementType[src.length + 6];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        private CharSequence[] expand(CharSequence[] src) {
            if (src == null) {
                return null;
            }
            CharSequence[] dest = new CharSequence[src.length + 6];
            System.arraycopy(src, 0, dest, 0, src.length);
            return dest;
        }

        static boolean isValidChar(char ch, int index) {
            return ElementsParser.isAlpha(ch) || ElementsParser.isNumeric(ch) || index != 0 && ch == '-';
        }

        static boolean isAlphaNumeric(char ch) {
            return ElementsParser.isAlpha(ch) || ElementsParser.isNumeric(ch);
        }

        private static boolean isAlpha(char ch) {
            return ch >= 'a' && ch <= 'z';
        }

        private static boolean isNumeric(char ch) {
            return ch >= '0' && ch <= '9';
        }
    }
}

