/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.function.Predicate;
import org.springframework.util.Assert;

public enum ConfigurationPropertyState {
    PRESENT,
    ABSENT,
    UNKNOWN;


    static <T> ConfigurationPropertyState search(Iterable<T> source2, Predicate<T> predicate) {
        Assert.notNull(source2, "'source' must not be null");
        Assert.notNull(predicate, "'predicate' must not be null");
        for (T item : source2) {
            if (!predicate.test(item)) continue;
            return PRESENT;
        }
        return ABSENT;
    }

    static <T> ConfigurationPropertyState search(T[] source2, int startInclusive, int endExclusive, Predicate<T> predicate) {
        Assert.notNull(source2, "'source' must not be null");
        Assert.notNull(predicate, "'predicate' must not be null");
        for (int i2 = startInclusive; i2 < endExclusive; ++i2) {
            if (!predicate.test(source2[i2])) continue;
            return PRESENT;
        }
        return ABSENT;
    }
}

