/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.reactive;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.springframework.boot.http.client.ReactorHttpClientBuilder;
import org.springframework.boot.http.client.reactive.AbstractClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.netty.http.client.HttpClient;

public final class ReactorClientHttpConnectorBuilder
extends AbstractClientHttpConnectorBuilder<ReactorClientHttpConnector> {
    private final ReactorHttpClientBuilder httpClientBuilder;

    ReactorClientHttpConnectorBuilder() {
        this(null, new ReactorHttpClientBuilder());
    }

    private ReactorClientHttpConnectorBuilder(List<Consumer<ReactorClientHttpConnector>> customizers, ReactorHttpClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public ReactorClientHttpConnectorBuilder withCustomizer(Consumer<ReactorClientHttpConnector> customizer2) {
        return new ReactorClientHttpConnectorBuilder(this.mergedCustomizers(customizer2), this.httpClientBuilder);
    }

    public ReactorClientHttpConnectorBuilder withCustomizers(Collection<Consumer<ReactorClientHttpConnector>> customizers) {
        return new ReactorClientHttpConnectorBuilder(this.mergedCustomizers(customizers), this.httpClientBuilder);
    }

    public ReactorClientHttpConnectorBuilder withReactorResourceFactory(ReactorResourceFactory reactorResourceFactory) {
        Assert.notNull((Object)reactorResourceFactory, "'reactorResourceFactory' must not be null");
        return new ReactorClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withReactorResourceFactory(reactorResourceFactory));
    }

    public ReactorClientHttpConnectorBuilder withHttpClientFactory(Supplier<HttpClient> factory2) {
        Assert.notNull(factory2, "'factory' must not be null");
        return new ReactorClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withHttpClientFactory(factory2));
    }

    public ReactorClientHttpConnectorBuilder withHttpClientCustomizer(UnaryOperator<HttpClient> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, "'httpClientCustomizer' must not be null");
        return new ReactorClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withHttpClientCustomizer(httpClientCustomizer));
    }

    @Override
    protected ReactorClientHttpConnector createClientHttpConnector(ClientHttpConnectorSettings settings) {
        HttpClient httpClient = this.httpClientBuilder.build(this.asHttpClientSettings(settings));
        return new ReactorClientHttpConnector(httpClient);
    }

    static class Classes {
        static final String HTTP_CLIENT = "reactor.netty.http.client.HttpClient";

        Classes() {
        }

        static boolean present(ClassLoader classLoader) {
            return ClassUtils.isPresent(HTTP_CLIENT, classLoader);
        }
    }
}

